/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Simple1D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.LabelVisualization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HistogramProjector<V extends NumberVector>
implements Projector {
    Relation<V> rel;
    int dmax;

    public HistogramProjector(Relation<V> relation, int n) {
        this.rel = relation;
        this.dmax = n;
        assert (n <= RelationUtil.dimensionality(relation)) : "Requested dimensionality larger than data dimensionality?!?";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext visualizerContext) {
        ArrayList<PlotItem> arrayList = new ArrayList<PlotItem>(1 + this.dmax);
        List<VisualizationTask> list = visualizerContext.getVisTasks(this);
        if (list.size() > 0) {
            Object object;
            Object object2;
            int n;
            double d = this.dmax > 1 ? 0.1 : 0.0;
            PlotItem plotItem = new PlotItem((double)this.dmax + d, 0.6, null);
            ScalesResult scalesResult = ResultUtil.getScalesResult(this.rel);
            for (n = 0; n < this.dmax; ++n) {
                object2 = new Simple1D(this, scalesResult.getScales(), n);
                object = new PlotItem((double)n + d, 0.1, 1.0, 0.5, (Projection)object2);
                ((PlotItem)object).tasks = list;
                plotItem.subitems.add((PlotItem)object);
            }
            arrayList.add(plotItem);
            for (n = 0; n < this.dmax; ++n) {
                object2 = new PlotItem((double)n + d, 0.0, 1.0, 0.1, null);
                object = new LabelVisualization(RelationUtil.getColumnLabel(this.rel, n));
                VisualizationTask visualizationTask = new VisualizationTask("", visualizerContext, null, null, (VisFactory)object);
                visualizationTask.reqheight = 0.1;
                visualizationTask.reqwidth = 1.0;
                visualizationTask.addFlags(2);
                ((PlotItem)object2).tasks.add(visualizationTask);
                plotItem.subitems.add((PlotItem)object2);
            }
        }
        return arrayList;
    }

    @Override
    public String getMenuName() {
        return "Axis plot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

