/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.OPTICSProjection;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OPTICSProjector
implements Projector {
    private ClusterOrder clusterOrder;
    private OPTICSPlot plot = null;

    public OPTICSProjector(ClusterOrder clusterOrder) {
        this.clusterOrder = clusterOrder;
    }

    @Override
    public String getMenuName() {
        return "OPTICS Plot Projection";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext visualizerContext) {
        ArrayList<PlotItem> arrayList = new ArrayList<PlotItem>(1);
        List<VisualizationTask> list = visualizerContext.getVisTasks(this);
        if (list.size() > 0) {
            PlotItem plotItem = new PlotItem(4.0, 1.0, new OPTICSProjection(this));
            plotItem.tasks = list;
            arrayList.add(plotItem);
        }
        return arrayList;
    }

    public ClusterOrder getResult() {
        return this.clusterOrder;
    }

    public OPTICSPlot getOPTICSPlot(VisualizerContext visualizerContext) {
        if (this.plot == null) {
            this.plot = OPTICSPlot.plotForClusterOrder(this.clusterOrder, visualizerContext);
        }
        return this.plot;
    }
}

