/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGPath {
    private StringBuilder buf = new StringBuilder();
    private String lastaction = null;
    public static final String PATH_SMOOTH_CUBIC_TO = "S";
    public static final String PATH_LINE_TO_RELATIVE = "L".toLowerCase();
    public static final String PATH_MOVE_RELATIVE = "M".toLowerCase();
    public static final String PATH_HORIZONTAL_LINE_TO_RELATIVE = "H".toLowerCase();
    public static final String PATH_VERTICAL_LINE_TO_RELATIVE = "V".toLowerCase();
    public static final String PATH_CUBIC_TO_RELATIVE = "C".toLowerCase();
    public static final String PATH_SMOOTH_CUBIC_TO_RELATIVE = "S".toLowerCase();
    public static final String PATH_QUAD_TO_RELATIVE = "Q".toLowerCase();
    public static final String PATH_SMOOTH_QUAD_TO_RELATIVE = "T".toLowerCase();
    public static final String PATH_ARC_RELATIVE = "A".toLowerCase();

    public SVGPath() {
    }

    public SVGPath(double d, double d2) {
        this();
        this.moveTo(d, d2);
    }

    public SVGPath(double[] dArray) {
        this();
        this.moveTo(dArray[0], dArray[1]);
    }

    public SVGPath(Polygon polygon) {
        this();
        ArrayListIter<Vector> arrayListIter = polygon.iter();
        while (arrayListIter.valid()) {
            Vector vector = arrayListIter.get();
            this.drawTo(vector.doubleValue(0), vector.doubleValue(1));
            arrayListIter.advance();
        }
        this.close();
    }

    public SVGPath drawTo(double d, double d2) {
        return !this.isStarted() ? this.moveTo(d, d2) : this.lineTo(d, d2);
    }

    public SVGPath drawTo(double[] dArray) {
        return !this.isStarted() ? this.moveTo(dArray[0], dArray[0]) : this.lineTo(dArray[0], dArray[1]);
    }

    public SVGPath drawTo(Vector vector) {
        return !this.isStarted() ? this.moveTo(vector.doubleValue(0), vector.doubleValue(1)) : this.lineTo(vector.doubleValue(0), vector.doubleValue(1));
    }

    public boolean isStarted() {
        return this.lastaction != null;
    }

    public SVGPath lineTo(double d, double d2) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY && d2 > Double.NEGATIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            this.append("L", d, d2);
        }
        return this;
    }

    public SVGPath lineTo(double[] dArray) {
        return this.lineTo(dArray[0], dArray[1]);
    }

    public SVGPath lineTo(Vector vector) {
        return this.lineTo(vector.doubleValue(0), vector.doubleValue(1));
    }

    public SVGPath relativeLineTo(double d, double d2) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY && d2 > Double.NEGATIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            this.append(PATH_LINE_TO_RELATIVE, d, d2);
        }
        return this;
    }

    public SVGPath relativeLineTo(double[] dArray) {
        return this.relativeLineTo(dArray[0], dArray[1]);
    }

    public SVGPath relativeLineTo(Vector vector) {
        return this.relativeLineTo(vector.doubleValue(0), vector.doubleValue(1));
    }

    public SVGPath horizontalLineTo(double d) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
            this.append("H", d);
        }
        return this;
    }

    public SVGPath relativeHorizontalLineTo(double d) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
            this.append(PATH_HORIZONTAL_LINE_TO_RELATIVE, d);
        }
        return this;
    }

    public SVGPath verticalLineTo(double d) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
            this.append("V", d);
        }
        return this;
    }

    public SVGPath relativeVerticalLineTo(double d) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
            this.append(PATH_VERTICAL_LINE_TO_RELATIVE, d);
        }
        return this;
    }

    public SVGPath moveTo(double d, double d2) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY && d2 > Double.NEGATIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            this.append("M", d, d2);
        }
        return this;
    }

    public SVGPath moveTo(double[] dArray) {
        return this.moveTo(dArray[0], dArray[1]);
    }

    public SVGPath moveTo(Vector vector) {
        return this.moveTo(vector.doubleValue(0), vector.doubleValue(1));
    }

    public SVGPath relativeMoveTo(double d, double d2) {
        if (d > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY && d2 > Double.NEGATIVE_INFINITY && d2 < Double.POSITIVE_INFINITY) {
            this.append(PATH_MOVE_RELATIVE, d, d2);
        }
        return this;
    }

    public SVGPath relativeMoveTo(double[] dArray) {
        return this.relativeMoveTo(dArray[0], dArray[1]);
    }

    public SVGPath relativeMoveTo(Vector vector) {
        return this.relativeMoveTo(vector.doubleValue(0), vector.doubleValue(1));
    }

    public SVGPath cubicTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.append("C", d, d2, d3, d4, d5, d6);
        return this;
    }

    public SVGPath cubicTo(double[] dArray, double[] dArray2, double[] dArray3) {
        this.append("C", dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1]);
        return this;
    }

    public SVGPath cubicTo(Vector vector, Vector vector2, Vector vector3) {
        this.append("C", vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1), vector3.doubleValue(0), vector3.doubleValue(1));
        return this;
    }

    public SVGPath relativeCubicTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.append(PATH_CUBIC_TO_RELATIVE, d, d2, d3, d4, d5, d6);
        return this;
    }

    public SVGPath relativeCubicTo(double[] dArray, double[] dArray2, double[] dArray3) {
        this.append(PATH_CUBIC_TO_RELATIVE, dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1]);
        return this;
    }

    public SVGPath relativeCubicTo(Vector vector, Vector vector2, Vector vector3) {
        this.append(PATH_CUBIC_TO_RELATIVE, vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1), vector3.doubleValue(0), vector3.doubleValue(1));
        return this;
    }

    public SVGPath smoothCubicTo(double d, double d2, double d3, double d4) {
        this.append(PATH_SMOOTH_CUBIC_TO, d, d2, d3, d4);
        return this;
    }

    public SVGPath smoothCubicTo(double[] dArray, double[] dArray2) {
        this.append(PATH_SMOOTH_CUBIC_TO, dArray[0], dArray[1], dArray2[0], dArray2[1]);
        return this;
    }

    public SVGPath smoothCubicTo(Vector vector, Vector vector2) {
        this.append(PATH_SMOOTH_CUBIC_TO, vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    public SVGPath relativeSmoothCubicTo(double d, double d2, double d3, double d4) {
        this.append(PATH_SMOOTH_CUBIC_TO_RELATIVE, d, d2, d3, d4);
        return this;
    }

    public SVGPath relativeSmoothCubicTo(double[] dArray, double[] dArray2) {
        this.append(PATH_SMOOTH_CUBIC_TO_RELATIVE, dArray[0], dArray[1], dArray2[0], dArray2[1]);
        return this;
    }

    public SVGPath relativeSmoothCubicTo(Vector vector, Vector vector2) {
        this.append(PATH_SMOOTH_CUBIC_TO_RELATIVE, vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    public SVGPath quadTo(double d, double d2, double d3, double d4) {
        this.append("Q", d, d2, d3, d4);
        return this;
    }

    public SVGPath quadTo(double[] dArray, double[] dArray2) {
        this.append("Q", dArray[0], dArray[1], dArray2[0], dArray2[1]);
        return this;
    }

    public SVGPath quadTo(Vector vector, Vector vector2) {
        this.append("Q", vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    public SVGPath relativeQuadTo(double d, double d2, double d3, double d4) {
        this.append(PATH_QUAD_TO_RELATIVE, d, d2, d3, d4);
        return this;
    }

    public SVGPath relativeQuadTo(double[] dArray, double[] dArray2) {
        this.append(PATH_QUAD_TO_RELATIVE, dArray[0], dArray[1], dArray2[0], dArray2[1]);
        return this;
    }

    public SVGPath relativeQuadTo(Vector vector, Vector vector2) {
        this.append(PATH_QUAD_TO_RELATIVE, vector.doubleValue(0), vector.doubleValue(1), vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    public SVGPath smoothQuadTo(double d, double d2) {
        this.append("T", d, d2);
        return this;
    }

    public SVGPath smoothQuadTo(double[] dArray) {
        this.append("T", dArray[0], dArray[1]);
        return this;
    }

    public SVGPath smoothQuadTo(Vector vector) {
        this.append("T", vector.doubleValue(0), vector.doubleValue(1));
        return this;
    }

    public SVGPath relativeSmoothQuadTo(double d, double d2) {
        this.append(PATH_SMOOTH_QUAD_TO_RELATIVE, d, d2);
        return this;
    }

    public SVGPath relativeSmoothQuadTo(double[] dArray) {
        this.append(PATH_SMOOTH_QUAD_TO_RELATIVE, dArray[0], dArray[1]);
        return this;
    }

    public SVGPath relativeSmoothQuadTo(Vector vector) {
        this.append(PATH_SMOOTH_QUAD_TO_RELATIVE, vector.doubleValue(0), vector.doubleValue(1));
        return this;
    }

    public SVGPath ellipticalArc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.append("A", d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public SVGPath ellipticalArc(double d, double d2, double d3, double d4, double d5, double[] dArray) {
        this.append("A", d, d2, d3, d4, d5, dArray[0], dArray[1]);
        return this;
    }

    public SVGPath ellipticalArc(Vector vector, double d, double d2, double d3, Vector vector2) {
        this.append("A", vector.doubleValue(0), vector.doubleValue(1), d, d2, d3, vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    public SVGPath relativeEllipticalArc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.append(PATH_ARC_RELATIVE, d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    public SVGPath relativeEllipticalArc(double d, double d2, double d3, double d4, double d5, double[] dArray) {
        this.append(PATH_ARC_RELATIVE, d, d2, d3, d4, d5, dArray[0], dArray[1]);
        return this;
    }

    public SVGPath relativeEllipticalArc(Vector vector, double d, double d2, double d3, Vector vector2) {
        this.append(PATH_ARC_RELATIVE, vector.doubleValue(0), vector.doubleValue(1), d, d2, d3, vector2.doubleValue(0), vector2.doubleValue(1));
        return this;
    }

    private void append(String string, double ... dArray) {
        if (this.lastaction != string) {
            this.buf.append(string);
            this.lastaction = string;
        }
        for (double d : dArray) {
            this.buf.append(SVGUtil.FMT.format(d));
            this.buf.append(' ');
        }
    }

    public SVGPath close() {
        if (this.lastaction != "Z") {
            this.buf.append("Z");
            this.lastaction = "Z";
        }
        return this;
    }

    public Element makeElement(Document document) {
        Element element = SVGUtil.svgElement(document, "path");
        element.setAttribute("d", this.buf.toString());
        return element;
    }

    public Element makeElement(SVGPlot sVGPlot) {
        Element element = sVGPlot.svgElement("path");
        element.setAttribute("d", this.buf.toString());
        return element;
    }

    public String toString() {
        return this.buf.toString();
    }
}

