/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractVisualization
implements Visualization,
ResultListener,
VisualizationListener,
DataStoreListener {
    protected final VisualizationTask task;
    protected final VisualizerContext context;
    protected final VisualizationPlot svgp;
    protected Element layer;
    private double width;
    private double height;

    public AbstractVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2) {
        this.task = visualizationTask;
        this.context = visualizationTask.getContext();
        this.svgp = visualizationPlot;
        this.width = d;
        this.height = d2;
        this.layer = null;
    }

    protected void addListeners() {
        this.context.addResultListener(this);
        this.context.addVisualizationListener(this);
        if (this.task.updateOnAny(1)) {
            this.context.addDataStoreListener(this);
        }
    }

    @Override
    public void destroy() {
        this.context.removeResultListener(this);
        this.context.removeVisualizationListener(this);
        this.context.removeDataStoreListener(this);
    }

    @Override
    public Element getLayer() {
        if (this.layer == null) {
            this.incrementalRedraw();
        }
        return this.layer;
    }

    protected double getWidth() {
        return this.width;
    }

    protected double getHeight() {
        return this.height;
    }

    @Override
    public void incrementalRedraw() {
        Node node = null;
        if (this.layer != null && this.layer.hasChildNodes()) {
            node = this.layer;
            this.layer = (Element)this.layer.cloneNode(false);
        }
        this.fullRedraw();
        if (node != null && node.getParentNode() != null) {
            node.getParentNode().replaceChild(this.layer, node);
        }
    }

    @Override
    public abstract void fullRedraw();

    @Override
    public void resultAdded(Result result, Result result2) {
    }

    @Override
    public void resultChanged(Result result) {
        if (this.task.getResult() == result) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
        if (this.task.updateOnAny(2) && result instanceof SelectionResult) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
        if (this.task.updateOnAny(8) && result instanceof SamplingResult) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }

    @Override
    public void resultRemoved(Result result, Result result2) {
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        if (this.task == visualizationItem || this.task.getResult() == visualizationItem) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
        if (this.task.updateOnAny(4) && visualizationItem instanceof StylingPolicy) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }

    @Override
    public void contentChanged(DataStoreEvent dataStoreEvent) {
        this.svgp.requestRedraw(this.task, this);
    }
}

