/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ParallelAxisVisualization
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(ParallelAxisVisualization.class);
    private static final String NAME = "Parallel Axes";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector, parallelPlotProjector.getRelation(), this);
            visualizationTask.level = 0;
            visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return true;
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String AXIS_LABEL = "paxis-label";
        public static final String INVERTEDAXIS = "paxis-button";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            this.addCSSClasses(this.svgp);
            int n = this.proj.getInputDimensionality();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.proj.isAxisVisible(i)) continue;
                int n3 = this.proj.getDimForAxis(i);
                double d = this.getVisibleAxisX(n2);
                try {
                    if (!this.proj.isAxisInverted(n2)) {
                        SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getAxisScale(i), d, this.getSizeY(), d, 0.0, SVGSimpleLinearAxis.LabelStyle.ENDLABEL, styleLibrary);
                    } else {
                        SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getAxisScale(i), d, 0.0, d, this.getSizeY(), SVGSimpleLinearAxis.LabelStyle.ENDLABEL, styleLibrary);
                    }
                }
                catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
                    LOG.warning("Conflict in CSS naming for axes.", cSSNamingConflict);
                    continue;
                }
                String string = RelationUtil.getColumnLabel(this.relation, n3);
                Element element = this.svgp.svgText(d, -0.7 * this.getMarginTop(), string);
                SVGUtil.setCSSClass(element, AXIS_LABEL);
                if (n > 10) {
                    SVGUtil.setAtt(element, "textLength", this.getAxisSep() * 0.95);
                    SVGUtil.setAtt(element, "lengthAdjust", "spacingAndGlyphs");
                }
                this.layer.appendChild(element);
                Element element2 = this.svgp.svgRect(d - this.getAxisSep() * 0.475, -this.getMarginTop(), 0.95 * this.getAxisSep(), 0.5 * this.getMarginTop());
                SVGUtil.setCSSClass(element2, INVERTEDAXIS);
                this.addEventListener(element2, n3);
                this.layer.appendChild(element2);
                ++n2;
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(AXIS_LABEL)) {
                cSSClass = new CSSClass(this, AXIS_LABEL);
                cSSClass.setStatement("fill", styleLibrary.getTextColor("axis.label"));
                cSSClass.setStatement("font-family", styleLibrary.getFontFamily("axis.label"));
                cSSClass.setStatement("font-size", styleLibrary.getTextSize("axis.label"));
                cSSClass.setStatement("text-anchor", "middle");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(INVERTEDAXIS)) {
                cSSClass = new CSSClass(this, INVERTEDAXIS);
                cSSClass.setStatement("opacity", 0.1);
                cSSClass.setStatement("fill", "grey");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }

        private void addEventListener(Element element, final int n) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            eventTarget.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    Instance.this.proj.toggleDimInverted(n);
                    Instance.this.context.visChanged(Instance.this.proj);
                }
            }, false);
        }
    }
}

