/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class AbstractTooltipVisualization
extends AbstractScatterplotVisualization
implements DataStoreListener {
    public static final String TOOLTIP_HIDDEN = "tooltip_hidden";
    public static final String TOOLTIP_VISIBLE = "tooltip_visible";
    public static final String TOOLTIP_STICKY = "tooltip_sticky";
    public static final String TOOLTIP_AREA = "tooltip_area";
    EventListener hoverer = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            AbstractTooltipVisualization.this.handleHoverEvent(event);
        }
    };

    public AbstractTooltipVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        super(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void fullRedraw() {
        this.setupCanvas();
        this.setupCSS(this.svgp);
        StyleLibrary styleLibrary = this.context.getStyleLibrary();
        double d = styleLibrary.getLineWidth("plot");
        DBIDIter dBIDIter = this.sample.getSample().iter();
        while (dBIDIter.valid()) {
            double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDIter));
            if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                Element element = this.makeTooltip(dBIDIter, dArray[0], dArray[1], d);
                SVGUtil.addCSSClass(element, TOOLTIP_HIDDEN);
                Element element2 = this.svgp.svgRect(dArray[0] - d, dArray[1] - d, 2.0 * d, 2.0 * d);
                SVGUtil.addCSSClass(element2, TOOLTIP_AREA);
                EventTarget eventTarget = (EventTarget)((Object)element2);
                eventTarget.addEventListener("mouseover", this.hoverer, false);
                eventTarget.addEventListener("mouseout", this.hoverer, false);
                eventTarget.addEventListener("click", this.hoverer, false);
                this.layer.appendChild(element2);
                this.layer.appendChild(element);
            }
            dBIDIter.advance();
        }
    }

    protected abstract Element makeTooltip(DBIDRef var1, double var2, double var4, double var6);

    protected void handleHoverEvent(Event event) {
        if (event.getTarget() instanceof Element) {
            Element element = (Element)((Object)event.getTarget());
            Node node = element.getNextSibling();
            if (node instanceof Element) {
                this.toggleTooltip((Element)node, event.getType());
            } else {
                LoggingUtil.warning("Tooltip sibling not found.");
            }
        } else {
            LoggingUtil.warning("Got event for non-Element?!?");
        }
    }

    protected void toggleTooltip(Element element, String string) {
        String string2 = element.getAttribute("class");
        if ("mouseover".equals(string)) {
            if (TOOLTIP_HIDDEN.equals(string2)) {
                SVGUtil.setAtt(element, "class", TOOLTIP_VISIBLE);
            }
        } else if ("mouseout".equals(string)) {
            if (TOOLTIP_VISIBLE.equals(string2)) {
                SVGUtil.setAtt(element, "class", TOOLTIP_HIDDEN);
            }
        } else if ("click".equals(string)) {
            if (TOOLTIP_STICKY.equals(string2)) {
                SVGUtil.setAtt(element, "class", TOOLTIP_HIDDEN);
            }
            if (TOOLTIP_HIDDEN.equals(string2) || TOOLTIP_VISIBLE.equals(string2)) {
                SVGUtil.setAtt(element, "class", TOOLTIP_STICKY);
            }
        }
    }

    protected abstract void setupCSS(SVGPlot var1);
}

