/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class AxisVisualization
extends AbstractVisFactory {
    private static final String NAME = "Axes";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector.getRelation(), scatterPlotProjector.getRelation(), this);
            visualizationTask.level = 0;
            visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            int n = RelationUtil.dimensionality(this.rel);
            double[] dArray = this.proj.fastProjectScaledToRenderSpace(new double[n]);
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray2[i] = 1.0;
            }
            dArray2 = this.proj.fastProjectScaledToRenderSpace(dArray2);
            double d = Math.atan2(dArray2[1] - dArray[1], dArray2[0] - dArray[0]);
            double d2 = 1.1 * styleLibrary.getTextSize("axis.label");
            CSSClass cSSClass = new CSSClass(AxisVisualization.class, "unmanaged");
            cSSClass.setStatement("font-size", SVGUtil.fmt(d2));
            cSSClass.setStatement("fill", styleLibrary.getTextColor("axis.label"));
            cSSClass.setStatement("font-family", styleLibrary.getFontFamily("axis.label"));
            for (int i = 0; i < n; ++i) {
                double[] dArray3 = new double[n];
                dArray3[i] = 1.0;
                double[] dArray4 = this.proj.fastProjectScaledToRenderSpace(dArray3);
                boolean bl = false;
                double d3 = Math.atan2(dArray4[1] - dArray[1], dArray4[0] - dArray[0]);
                if (d3 > d || d > 0.0 && d3 > d + Math.PI) {
                    bl = true;
                }
                if (dArray4[0] == dArray[0] && dArray4[1] == dArray[1]) continue;
                try {
                    SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, this.proj.getScale(i), dArray[0], dArray[1], dArray4[0], dArray4[1], bl ? SVGSimpleLinearAxis.LabelStyle.RIGHTHAND : SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
                    double d4 = (double)(bl ? 1 : -1) * 0.02 * 100.0;
                    double d5 = (double)(bl ? 1 : -1) * 0.02 * 100.0;
                    Element element = this.svgp.svgText(dArray4[0] + d4, dArray4[1] + d5, RelationUtil.getColumnLabel(this.rel, i));
                    SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
                    SVGUtil.setAtt(element, "text-anchor", bl ? "start" : "end");
                    this.layer.appendChild(element);
                    continue;
                }
                catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
                    throw new RuntimeException("Conflict in CSS naming for axes.", cSSNamingConflict);
                }
            }
        }
    }
}

