/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.ExternalID;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractTooltipVisualization;
import org.w3c.dom.Element;

public class TooltipStringVisualization
extends AbstractVisFactory {
    public static final String NAME_ID = "ID Tooltips";
    public static final String NAME_LABEL = "Object Label Tooltips";
    public static final String NAME_CLASS = "Class Label Tooltips";
    public static final String NAME_EID = "External ID Tooltips";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, Relation.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<Relation<?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, Relation<?> relation, ScatterPlotProjector<?> scatterPlotProjector) {
                VisualizationTask visualizationTask;
                Relation<?> relation2 = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation2.getDataTypeInformation())) {
                    return;
                }
                Class<?> clazz = relation.getDataTypeInformation().getRestrictionClass();
                if (DBID.class.isAssignableFrom(clazz)) {
                    visualizationTask = new VisualizationTask(TooltipStringVisualization.NAME_ID, visualizerContext, relation, relation2, TooltipStringVisualization.this);
                    visualizationTask.tool = true;
                    visualizationTask.addUpdateFlags(9);
                    visualizationTask.initDefaultVisibility(false);
                    visualizerContext.addVis(relation, visualizationTask);
                    visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                }
                if (ClassLabel.class.isAssignableFrom(relation.getDataTypeInformation().getRestrictionClass())) {
                    visualizationTask = new VisualizationTask(TooltipStringVisualization.NAME_CLASS, visualizerContext, relation, relation2, TooltipStringVisualization.this);
                    visualizationTask.tool = true;
                    visualizationTask.addUpdateFlags(9);
                    visualizationTask.initDefaultVisibility(false);
                    visualizerContext.addVis(relation, visualizationTask);
                    visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                }
                if (LabelList.class.isAssignableFrom(relation.getDataTypeInformation().getRestrictionClass())) {
                    visualizationTask = new VisualizationTask(TooltipStringVisualization.NAME_LABEL, visualizerContext, relation, relation2, TooltipStringVisualization.this);
                    visualizationTask.tool = true;
                    visualizationTask.addUpdateFlags(9);
                    visualizationTask.initDefaultVisibility(false);
                    visualizerContext.addVis(relation, visualizationTask);
                    visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                }
                if (ExternalID.class.isAssignableFrom(relation.getDataTypeInformation().getRestrictionClass())) {
                    visualizationTask = new VisualizationTask(TooltipStringVisualization.NAME_EID, visualizerContext, relation, relation2, TooltipStringVisualization.this);
                    visualizationTask.tool = true;
                    visualizationTask.addUpdateFlags(9);
                    visualizationTask.initDefaultVisibility(false);
                    visualizerContext.addVis(relation, visualizationTask);
                    visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                }
            }
        });
    }

    public class Instance
    extends AbstractTooltipVisualization {
        private Relation<?> result;
        private double fontsize;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (Relation)visualizationTask.getResult();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            this.fontsize = 3.0 * styleLibrary.getTextSize("plot");
            this.addListeners();
        }

        @Override
        protected Element makeTooltip(DBIDRef dBIDRef, double d, double d2, double d3) {
            Object obj = this.result.get(dBIDRef);
            String string = obj == null ? "null" : obj.toString();
            string = string == "" || string == null ? "null" : string;
            return this.svgp.svgText(d + d3, d2 + this.fontsize * 0.07, string);
        }

        @Override
        protected void setupCSS(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d = styleLibrary.getTextSize("plot");
            String string = styleLibrary.getFontFamily("plot");
            CSSClass cSSClass = new CSSClass(sVGPlot, "tooltip_hidden");
            cSSClass.setStatement("font-size", d);
            cSSClass.setStatement("font-family", string);
            cSSClass.setStatement("display", "none");
            sVGPlot.addCSSClassOrLogError(cSSClass);
            CSSClass cSSClass2 = new CSSClass(sVGPlot, "tooltip_visible");
            cSSClass2.setStatement("font-size", d);
            cSSClass2.setStatement("font-family", string);
            sVGPlot.addCSSClassOrLogError(cSSClass2);
            CSSClass cSSClass3 = new CSSClass(sVGPlot, "tooltip_sticky");
            cSSClass3.setStatement("font-size", d);
            cSSClass3.setStatement("font-family", string);
            sVGPlot.addCSSClassOrLogError(cSSClass3);
            CSSClass cSSClass4 = new CSSClass(sVGPlot, "tooltip_area");
            cSSClass4.setStatement("fill", "red");
            cSSClass4.setStatement("stroke", "none");
            cSSClass4.setStatement("fill-opacity", "0");
            cSSClass4.setStatement("cursor", "pointer");
            sVGPlot.addCSSClassOrLogError(cSSClass4);
        }
    }
}

