/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class SelectionCubeVisualization
extends AbstractVisFactory {
    private static final String NAME = "Selection Range";
    protected Parameterizer settings;

    public SelectionCubeVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 98;
                visualizationTask.addUpdateFlags(2);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOFILL_ID = new OptionID("selectionrange.nofill", "Use wireframe style for selection ranges.");
        protected boolean nofill;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(NOFILL_ID);
            if (parameterization.grab(flag)) {
                this.nofill = flag.isTrue();
            }
        }

        @Override
        protected SelectionCubeVisualization makeInstance() {
            return new SelectionCubeVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String MARKER = "selectionCubeMarker";
        public static final String CSS_CUBE = "selectionCube";
        public static final String CSS_CUBEFRAME = "selectionCubeFrame";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(CSS_CUBE)) {
                cSSClass = new CSSClass(this, CSS_CUBE);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("stroke-opacity", styleLibrary.getOpacity("plot.selection"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                if (SelectionCubeVisualization.this.settings.nofill) {
                    cSSClass.setStatement("fill", "none");
                } else {
                    cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection"));
                    cSSClass.setStatement("fill-opacity", styleLibrary.getOpacity("plot.selection"));
                }
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(CSS_CUBEFRAME)) {
                cSSClass = new CSSClass(this, CSS_CUBEFRAME);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("stroke-opacity", styleLibrary.getOpacity("plot.selection"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot.selection"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }

        private void setSVGRect(SVGPlot sVGPlot, Projection2D projection2D) {
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection instanceof RangeSelection) {
                ModifiableHyperBoundingBox modifiableHyperBoundingBox = ((RangeSelection)dBIDSelection).getRanges();
                if (SelectionCubeVisualization.this.settings.nofill) {
                    Element element = SVGHyperCube.drawFrame(sVGPlot, projection2D, modifiableHyperBoundingBox);
                    SVGUtil.setCSSClass(element, CSS_CUBEFRAME);
                    this.layer.appendChild(element);
                } else {
                    Element element = SVGHyperCube.drawFilled(sVGPlot, CSS_CUBE, projection2D, modifiableHyperBoundingBox);
                    this.layer.appendChild(element);
                }
            }
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection instanceof RangeSelection) {
                this.setSVGRect(this.svgp, this.proj);
            }
        }
    }
}

