/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.batikutil.ThumbnailRegistryEntry;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs.ThumbnailThread;
import java.awt.image.BufferedImage;
import org.w3c.dom.Element;

public class ThumbnailVisualization
extends AbstractVisualization
implements ThumbnailThread.Listener,
DataStoreListener,
VisualizationListener {
    protected final VisFactory visFactory;
    protected int thumbid = -1;
    protected ThumbnailThread.Task pendingThumbnail = null;
    protected int tresolution;
    private BufferedImage thumb;
    private SVGPlot plot;
    private Projection proj;

    public ThumbnailVisualization(VisFactory visFactory, VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection, int n) {
        super(visualizationTask, visualizationPlot, d, d2);
        this.visFactory = visFactory;
        this.plot = visualizationPlot;
        this.proj = projection;
        this.tresolution = n;
        this.layer = visualizationPlot.svgElement("g");
        this.thumbid = -1;
        this.thumb = null;
        this.addListeners();
    }

    @Override
    public void destroy() {
        if (this.pendingThumbnail != null) {
            ThumbnailThread.UNQUEUE(this.pendingThumbnail);
        }
        super.destroy();
    }

    @Override
    public Element getLayer() {
        if (this.thumbid < 0) {
            this.svgp.requestRedraw(this.task, this);
        }
        return this.layer;
    }

    @Override
    public void fullRedraw() {
        if (!(this.getWidth() > 0.0) || !(this.getHeight() > 0.0)) {
            LoggingUtil.warning("Thumbnail of zero size requested: " + this.visFactory);
            return;
        }
        if (this.thumbid < 0) {
            this.layer.appendChild(SVGUtil.svgWaitIcon(this.plot.getDocument(), 0.0, 0.0, this.getWidth(), this.getHeight()));
            if (this.pendingThumbnail == null) {
                this.pendingThumbnail = ThumbnailThread.QUEUE(this);
            }
            return;
        }
        Element element = this.plot.svgElement("image");
        SVGUtil.setAtt(element, "x", 0);
        SVGUtil.setAtt(element, "y", 0);
        SVGUtil.setAtt(element, "width", this.getWidth());
        SVGUtil.setAtt(element, "height", this.getHeight());
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "thumb:" + this.thumbid);
        this.layer.appendChild(element);
    }

    @Override
    public synchronized void doThumbnail() {
        this.pendingThumbnail = null;
        try {
            VisualizationPlot visualizationPlot = new VisualizationPlot();
            visualizationPlot.getRoot().setAttribute("viewBox", "0 0 " + this.getWidth() + " " + this.getHeight());
            Visualization visualization = this.visFactory.makeVisualization(this.task, visualizationPlot, this.getWidth(), this.getHeight(), this.proj);
            visualizationPlot.getRoot().appendChild(visualization.getLayer());
            visualizationPlot.updateStyleElement();
            int n = (int)(this.getWidth() * (double)this.tresolution);
            int n2 = (int)(this.getHeight() * (double)this.tresolution);
            this.thumb = visualizationPlot.makeAWTImage(n, n2);
            this.thumbid = ThumbnailRegistryEntry.registerImage(this.thumb);
            visualization.destroy();
            this.svgp.requestRedraw(this.task, this);
        }
        catch (Exception exception) {
            Logging logging = Logging.getLogger(this.task.getFactory().getClass());
            if (logging != null && logging.isDebugging()) {
                logging.exception("Thumbnail for " + this.task.getFactory() + " failed.", exception);
            }
            LoggingUtil.warning("Thumbnail for " + this.task.getFactory() + " failed - enable debugging to see details.");
        }
    }

    private void refreshThumbnail() {
        this.thumbid = -1;
        this.thumb = null;
        this.svgp.requestRedraw(this.task, this);
    }

    @Override
    public void resultChanged(Result result) {
        if (this.task == result || this.task.getResult() == result) {
            this.refreshThumbnail();
            return;
        }
        if (this.task.updateOnAny(2) && result instanceof SelectionResult) {
            this.refreshThumbnail();
            return;
        }
        if (this.task.updateOnAny(8) && result instanceof SamplingResult) {
            this.refreshThumbnail();
            return;
        }
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        if (this.task == visualizationItem || this.task.updateOnAny(4) && visualizationItem instanceof StylingPolicy) {
            this.refreshThumbnail();
            return;
        }
    }
}

