/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import weka.classifiers.trees.ADTree;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.WekaEnumeration;

public final class PredictionNode
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = 6018958856358698814L;
    private double value;
    private final ArrayList<Splitter> children;

    public PredictionNode(double newValue) {
        this.value = newValue;
        this.children = new ArrayList();
    }

    public final void setValue(double newValue) {
        this.value = newValue;
    }

    public final double getValue() {
        return this.value;
    }

    public final ArrayList<Splitter> getChildren() {
        return this.children;
    }

    public final Enumeration<Splitter> children() {
        return new WekaEnumeration(this.children);
    }

    public final void addChild(Splitter newChild, ADTree addingTo) {
        Splitter oldEqual = null;
        Enumeration<Splitter> e = this.children();
        while (e.hasMoreElements()) {
            Splitter split = e.nextElement();
            if (!newChild.equalTo(split)) continue;
            oldEqual = split;
            break;
        }
        if (oldEqual == null) {
            Splitter addChild = (Splitter)newChild.clone();
            this.setOrderAddedSubtree(addChild, addingTo);
            this.children.add(addChild);
        } else {
            for (int i = 0; i < newChild.getNumOfBranches(); ++i) {
                PredictionNode oldPred = oldEqual.getChildForBranch(i);
                PredictionNode newPred = newChild.getChildForBranch(i);
                if (oldPred == null || newPred == null) continue;
                oldPred.merge(newPred, addingTo);
            }
        }
    }

    public final Object clone() {
        PredictionNode clone = new PredictionNode(this.value);
        WekaEnumeration e = new WekaEnumeration(this.children);
        while (e.hasMoreElements()) {
            clone.children.add((Splitter)((Splitter)e.nextElement()).clone());
        }
        return clone;
    }

    public final void merge(PredictionNode merger, ADTree mergingTo) {
        this.value += merger.value;
        Enumeration<Splitter> e = merger.children();
        while (e.hasMoreElements()) {
            this.addChild(e.nextElement(), mergingTo);
        }
    }

    private final void setOrderAddedSubtree(Splitter addChild, ADTree addingTo) {
        addChild.orderAdded = addingTo.nextSplitAddedOrder();
        for (int i = 0; i < addChild.getNumOfBranches(); ++i) {
            PredictionNode node = addChild.getChildForBranch(i);
            if (node == null) continue;
            Enumeration<Splitter> e = node.children();
            while (e.hasMoreElements()) {
                this.setOrderAddedSubtree(e.nextElement(), addingTo);
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10324 $");
    }
}

