/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering;

import de.lmu.ifi.dbs.elki.algorithm.clustering.biclustering.AbstractBiclustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.BiclusterWithInversionsModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="Y. Cheng, G. M. Church", title="Biclustering of expression data", booktitle="Proc. 8th International Conference on Intelligent Systems for Molecular Biology (ISMB)")
public class ChengAndChurch<V extends NumberVector>
extends AbstractBiclustering<V, BiclusterWithInversionsModel> {
    private static final Logging LOG = Logging.getLogger(ChengAndChurch.class);
    private static final int MIN_COLUMN_REMOVE_THRESHOLD = 100;
    private static final int MIN_ROW_REMOVE_THRESHOLD = 100;
    private double delta;
    private double alpha;
    private int n;
    private boolean useinverted = true;
    private Distribution dist;

    public ChengAndChurch(double d, double d2, int n, Distribution distribution) {
        this.delta = d;
        this.alpha = d2;
        this.n = n;
        this.dist = distribution;
    }

    @Override
    public Clustering<BiclusterWithInversionsModel> biclustering() {
        BiclusterWithInversionsModel biclusterWithInversionsModel;
        double[][] dArray = RelationUtil.relationAsMatrix(this.relation, this.rowIDs);
        BiclusterCandidate biclusterCandidate = new BiclusterCandidate(this.getRowDim(), this.getColDim());
        Clustering<BiclusterWithInversionsModel> clustering = new Clustering<BiclusterWithInversionsModel>("Cheng-and-Church", "Cheng and Church Biclustering");
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(this.relation.getDBIDs());
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extracting Cluster", this.n, LOG) : null;
        for (int i = 0; i < this.n; ++i) {
            biclusterCandidate.reset();
            this.multipleNodeDeletion(dArray, biclusterCandidate);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 2: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
            }
            this.singleNodeDeletion(dArray, biclusterCandidate);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 1: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
            }
            this.nodeAddition(dArray, biclusterCandidate);
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Residue after Alg 3: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
            }
            biclusterCandidate.maskMatrix(dArray, this.dist);
            biclusterWithInversionsModel = new BiclusterWithInversionsModel(this.colsBitsetToIDs(biclusterCandidate.cols), this.rowsBitsetToIDs(biclusterCandidate.irow));
            ArrayDBIDs arrayDBIDs = this.rowsBitsetToIDs(biclusterCandidate.rows);
            hashSetModifiableDBIDs.removeDBIDs(arrayDBIDs);
            clustering.addToplevelCluster(new Cluster<BiclusterWithInversionsModel>((DBIDs)arrayDBIDs, biclusterWithInversionsModel));
            if (LOG.isVerbose()) {
                LOG.verbose("Score of bicluster " + (i + 1) + ": " + biclusterCandidate.residue + "\n");
                LOG.verbose("Number of rows: " + biclusterCandidate.rowcard + "\n");
                LOG.verbose("Number of columns: " + biclusterCandidate.colcard + "\n");
            }
            LOG.incrementProcessed(finiteProgress);
        }
        if (!hashSetModifiableDBIDs.isEmpty()) {
            long[] lArray = BitsUtil.ones(this.getColDim());
            biclusterWithInversionsModel = new BiclusterWithInversionsModel(this.colsBitsetToIDs(lArray), DBIDUtil.EMPTYDBIDS);
            clustering.addToplevelCluster(new Cluster<BiclusterWithInversionsModel>(hashSetModifiableDBIDs, true, biclusterWithInversionsModel));
        }
        LOG.ensureCompleted(finiteProgress);
        return clustering;
    }

    private void singleNodeDeletion(final double[][] dArray, final BiclusterCandidate biclusterCandidate) {
        while (biclusterCandidate.residue > this.delta && (biclusterCandidate.colcard > 2 || biclusterCandidate.rowcard > 2)) {
            final double[] dArray2 = new double[]{Double.NEGATIVE_INFINITY};
            final int[] nArray = new int[]{-1, -1};
            if (biclusterCandidate.rowcard > 2) {
                biclusterCandidate.visitColumn(dArray, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                        assert (bl);
                        double d2 = biclusterCandidate.computeRowResidue(dArray, n, false);
                        if (dArray2[0] < d2) {
                            dArray2[0] = d2;
                            nArray[0] = n;
                        }
                        return false;
                    }
                });
            }
            if (biclusterCandidate.colcard > 2) {
                biclusterCandidate.visitRow(dArray, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                        assert (bl2);
                        double d2 = biclusterCandidate.computeColResidue(dArray, n2);
                        if (dArray2[0] < d2) {
                            dArray2[0] = d2;
                            nArray[1] = n2;
                        }
                        return false;
                    }
                });
            }
            if (nArray[1] >= 0) {
                biclusterCandidate.selectColumn(nArray[1], false);
            } else {
                assert (nArray[0] >= 0);
                biclusterCandidate.selectRow(nArray[0], false);
            }
            biclusterCandidate.updateRowAndColumnMeans(dArray, false);
            biclusterCandidate.computeMeanSquaredDeviation(dArray);
            if (!LOG.isDebuggingFine()) continue;
            LOG.debugFine("Residue in Alg 1: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
        }
    }

    private void multipleNodeDeletion(final double[][] dArray, final BiclusterCandidate biclusterCandidate) {
        biclusterCandidate.updateRowAndColumnMeans(dArray, false);
        biclusterCandidate.computeMeanSquaredDeviation(dArray);
        while (biclusterCandidate.residue > this.delta) {
            double d;
            final boolean[] blArray = new boolean[]{false, false};
            if (biclusterCandidate.rowcard > 100) {
                d = this.alpha * biclusterCandidate.residue;
                biclusterCandidate.visitColumn(dArray, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double d2, int n, int n2, boolean bl, boolean bl2) {
                        assert (bl);
                        if (biclusterCandidate.computeRowResidue(dArray, n, false) > d) {
                            biclusterCandidate.selectRow(n, false);
                            blArray[0] = true;
                        }
                        return biclusterCandidate.rowcard > 100;
                    }
                });
                if (blArray[0]) {
                    biclusterCandidate.updateRowAndColumnMeans(dArray, false);
                    biclusterCandidate.computeMeanSquaredDeviation(dArray);
                }
            }
            if (biclusterCandidate.colcard > 100) {
                d = this.alpha * biclusterCandidate.residue;
                biclusterCandidate.visitRow(dArray, 0, 1, new CellVisitor(){

                    @Override
                    public boolean visit(double d2, int n, int n2, boolean bl, boolean bl2) {
                        assert (bl2);
                        if (biclusterCandidate.computeColResidue(dArray, n2) > d) {
                            biclusterCandidate.selectColumn(n2, false);
                            blArray[1] = true;
                        }
                        return biclusterCandidate.colcard > 100;
                    }
                });
                if (blArray[1]) {
                    biclusterCandidate.updateRowAndColumnMeans(dArray, false);
                    biclusterCandidate.computeMeanSquaredDeviation(dArray);
                }
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Residue in Alg 2: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
            }
            if (blArray[0] || blArray[1]) continue;
            break;
        }
    }

    private void nodeAddition(final double[][] dArray, final BiclusterCandidate biclusterCandidate) {
        boolean[] blArray;
        biclusterCandidate.updateRowAndColumnMeans(dArray, true);
        biclusterCandidate.computeMeanSquaredDeviation(dArray);
        do {
            blArray = new boolean[]{false, false};
            biclusterCandidate.visitRow(dArray, 0, 2, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    assert (!bl2);
                    if (biclusterCandidate.computeColResidue(dArray, n2) <= biclusterCandidate.residue) {
                        biclusterCandidate.selectColumn(n2, true);
                        blArray[0] = true;
                    }
                    return false;
                }
            });
            if (blArray[0]) {
                biclusterCandidate.updateRowAndColumnMeans(dArray, true);
                biclusterCandidate.computeMeanSquaredDeviation(dArray);
            }
            biclusterCandidate.visitColumn(dArray, 0, 2, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    assert (!bl);
                    if (biclusterCandidate.computeRowResidue(dArray, n, false) <= biclusterCandidate.residue) {
                        biclusterCandidate.selectRow(n, true);
                        blArray[1] = true;
                    }
                    return false;
                }
            });
            if (this.useinverted) {
                biclusterCandidate.visitColumn(dArray, 0, 2, new CellVisitor(){

                    @Override
                    public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                        assert (!bl);
                        if (biclusterCandidate.computeRowResidue(dArray, n, true) <= biclusterCandidate.residue) {
                            biclusterCandidate.selectRow(n, true);
                            biclusterCandidate.invertRow(n, true);
                            blArray[1] = true;
                        }
                        return false;
                    }
                });
            }
            if (!blArray[1]) continue;
            biclusterCandidate.updateRowAndColumnMeans(dArray, true);
            biclusterCandidate.computeMeanSquaredDeviation(dArray);
            if (!LOG.isDebuggingFine()) continue;
            LOG.debugFine("Residue in Alg 3: " + biclusterCandidate.residue + " " + biclusterCandidate.rowcard + "x" + biclusterCandidate.colcard);
        } while (blArray[0] || blArray[1]);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIST_ID = new OptionID("chengandchurch.replacement", "Distribution of replacement values when masking found clusters.");
        public static final OptionID DELTA_ID = new OptionID("chengandchurch.delta", "Threshold value to determine the maximal acceptable score (mean squared residue) of a bicluster.");
        public static final OptionID ALPHA_ID = new OptionID("chengandchurch.alpha", "Parameter for multiple node deletion to accelerate the algorithm.");
        public static final OptionID N_ID = new OptionID("chengandchurch.n", "The number of biclusters to be found.");
        private double delta;
        private double alpha;
        private int n;
        private Distribution dist;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(DELTA_ID);
            if (parameterization.grab(doubleParameter)) {
                this.delta = doubleParameter.doubleValue();
            }
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            IntParameter intParameter = new IntParameter(N_ID, 1);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.n = intParameter.intValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(ALPHA_ID, 1.0);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.alpha = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(DIST_ID, (Class<?>)Distribution.class, UniformDistribution.class))) {
                this.dist = (Distribution)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ChengAndChurch<V> makeInstance() {
            return new ChengAndChurch(this.delta, this.alpha, this.n, this.dist);
        }
    }

    protected static class BiclusterCandidate {
        int rowcard;
        int colcard;
        double[] rowM;
        double[] colM;
        long[] rows;
        long[] irow;
        long[] cols;
        double allM;
        double residue;
        private final CellVisitor MEANVISITOR = new CellVisitor(){

            @Override
            public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                if (bl2) {
                    int n3 = n;
                    BiclusterCandidate.this.rowM[n3] = BiclusterCandidate.this.rowM[n3] + d;
                }
                if (bl) {
                    int n4 = n2;
                    BiclusterCandidate.this.colM[n4] = BiclusterCandidate.this.colM[n4] + d;
                }
                if (bl2 && bl) {
                    BiclusterCandidate.this.allM += d;
                }
                return false;
            }
        };

        protected BiclusterCandidate(int n, int n2) {
            this.rows = BitsUtil.ones(n);
            this.irow = BitsUtil.zero(n);
            this.rowcard = n;
            this.rowM = new double[n];
            this.cols = BitsUtil.ones(n2);
            this.colcard = n2;
            this.colM = new double[n2];
        }

        protected void reset() {
            this.rows = BitsUtil.ones(this.rowM.length);
            this.rowcard = this.rowM.length;
            this.cols = BitsUtil.ones(this.colM.length);
            this.colcard = this.colM.length;
            BitsUtil.zeroI(this.irow);
        }

        protected void visitAll(double[][] dArray, int n, CellVisitor cellVisitor) {
            int n2 = 0;
            for (int i = 0; i < this.rows.length; ++i) {
                long l = this.rows[i];
                if (n == 1 && l == 0L || n == 2 && l == -1L) {
                    n2 += 64;
                    continue;
                }
                int n3 = 0;
                while (n3 < 64 && n2 < this.rowM.length) {
                    boolean bl;
                    boolean bl2 = bl = (l & 1L) == 1L;
                    if (!(n == 1 && !bl || n == 2 && bl)) {
                        int n4 = 0;
                        for (int j = 0; j < this.cols.length; ++j) {
                            long l2 = this.cols[j];
                            if (n == 1 && l2 == 0L || n == 2 && l2 == -1L) {
                                n4 += 64;
                                continue;
                            }
                            int n5 = 0;
                            while (n5 < 64 && n4 < this.colM.length) {
                                boolean bl3;
                                boolean bl4;
                                boolean bl5 = bl4 = (l2 & 1L) == 1L;
                                if (!(n == 1 && !bl4 || n == 2 && bl4 || !(bl3 = cellVisitor.visit(dArray[n2][n4], n2, n4, bl, bl4)))) {
                                    return;
                                }
                                ++n5;
                                ++n4;
                                l2 >>>= 1;
                            }
                        }
                    }
                    ++n3;
                    ++n2;
                    l >>>= 1;
                }
            }
        }

        protected void visitColumn(double[][] dArray, int n, int n2, CellVisitor cellVisitor) {
            boolean bl = BitsUtil.get(this.cols, n);
            int n3 = 0;
            for (int i = 0; i < this.rows.length; ++i) {
                long l = this.rows[i];
                if (n2 == 1 && l == 0L) {
                    n3 += 64;
                    continue;
                }
                if (n2 == 2 && l == -1L) {
                    n3 += 64;
                    continue;
                }
                int n4 = 0;
                while (n4 < 64 && n3 < this.rowM.length) {
                    boolean bl2;
                    boolean bl3;
                    boolean bl4 = bl3 = (l & 1L) == 1L;
                    if (!(n2 == 1 && !bl3 || n2 == 2 && bl3 || !(bl2 = cellVisitor.visit(dArray[n3][n], n3, n, bl3, bl)))) {
                        return;
                    }
                    ++n4;
                    ++n3;
                    l >>>= 1;
                }
            }
        }

        protected void visitRow(double[][] dArray, int n, int n2, CellVisitor cellVisitor) {
            boolean bl = BitsUtil.get(this.rows, n);
            double[] dArray2 = dArray[n];
            int n3 = 0;
            for (int i = 0; i < this.cols.length; ++i) {
                long l = this.cols[i];
                if (n2 == 1 && l == 0L) {
                    n3 += 64;
                    continue;
                }
                if (n2 == 2 && l == -1L) {
                    n3 += 64;
                    continue;
                }
                int n4 = 0;
                while (n4 < 64 && n3 < this.colM.length) {
                    boolean bl2;
                    boolean bl3;
                    boolean bl4 = bl3 = (l & 1L) == 1L;
                    if (!(n2 == 1 && !bl3 || n2 == 2 && bl3 || !(bl2 = cellVisitor.visit(dArray2[n3], n, n3, bl, bl3)))) {
                        return;
                    }
                    ++n4;
                    ++n3;
                    l >>>= 1;
                }
            }
        }

        protected double updateRowAndColumnMeans(double[][] dArray, boolean bl) {
            int n = bl ? 0 : 1;
            Arrays.fill(this.rowM, 0.0);
            Arrays.fill(this.colM, 0.0);
            this.allM = 0.0;
            this.visitAll(dArray, n, this.MEANVISITOR);
            this.visitColumn(dArray, 0, n, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    int n3 = n;
                    BiclusterCandidate.this.rowM[n3] = BiclusterCandidate.this.rowM[n3] / (double)BiclusterCandidate.this.colcard;
                    return false;
                }
            });
            this.visitRow(dArray, 0, n, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    int n3 = n2;
                    BiclusterCandidate.this.colM[n3] = BiclusterCandidate.this.colM[n3] / (double)BiclusterCandidate.this.rowcard;
                    return false;
                }
            });
            this.allM /= (double)(this.colcard * this.rowcard);
            return this.allM;
        }

        protected double computeMeanSquaredDeviation(double[][] dArray) {
            final Mean mean = new Mean();
            this.visitAll(dArray, 1, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    assert (bl && bl2);
                    double d2 = d - BiclusterCandidate.this.rowM[n] - BiclusterCandidate.this.colM[n2] + BiclusterCandidate.this.allM;
                    mean.put(d2 * d2);
                    return false;
                }
            });
            this.residue = mean.getMean();
            return this.residue;
        }

        protected double computeRowResidue(double[][] dArray, int n, final boolean bl) {
            final Mean mean = new Mean();
            this.visitRow(dArray, n, 1, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl3, boolean bl2) {
                    assert (bl2);
                    double d2 = BiclusterCandidate.this.rowM[n];
                    double d3 = BiclusterCandidate.this.colM[n2];
                    double d4 = (!bl ? d - d2 : d2 - d) - d3 + BiclusterCandidate.this.allM;
                    mean.put(d4 * d4);
                    return false;
                }
            });
            return mean.getMean();
        }

        protected double computeColResidue(double[][] dArray, int n) {
            final double d = this.colM[n] - this.allM;
            final Mean mean = new Mean();
            this.visitColumn(dArray, n, 1, new CellVisitor(){

                @Override
                public boolean visit(double d4, int n, int n2, boolean bl, boolean bl2) {
                    assert (bl);
                    double d2 = BiclusterCandidate.this.rowM[n];
                    double d3 = d4 - d2 - d;
                    mean.put(d3 * d3);
                    return false;
                }
            });
            return mean.getMean();
        }

        protected void maskMatrix(final double[][] dArray, final Distribution distribution) {
            this.visitAll(dArray, 1, new CellVisitor(){

                @Override
                public boolean visit(double d, int n, int n2, boolean bl, boolean bl2) {
                    assert (bl && bl2);
                    dArray[n][n2] = distribution.nextRandom();
                    return false;
                }
            });
        }

        protected void selectColumn(int n, boolean bl) {
            if (bl) {
                BitsUtil.setI(this.cols, n);
                ++this.colcard;
            } else {
                BitsUtil.clearI(this.cols, n);
                --this.colcard;
            }
        }

        protected void selectRow(int n, boolean bl) {
            if (bl) {
                BitsUtil.setI(this.rows, n);
                ++this.rowcard;
            } else {
                BitsUtil.clearI(this.rows, n);
                --this.rowcard;
            }
        }

        protected void invertRow(int n, boolean bl) {
            BitsUtil.setI(this.irow, n);
        }
    }

    public static interface CellVisitor {
        public static final int ALL = 0;
        public static final int SELECTED = 1;
        public static final int NOT_SELECTED = 2;

        public boolean visit(double var1, int var3, int var4, boolean var5, boolean var6);
    }
}

