/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.COPACNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.DimensionModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="COPAC: COrrelation PArtition Clustering")
@Description(value="Partitions a database according to the correlation dimension of its objects and performs a clustering algorithm over the partitions.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, A. Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM International Conference on Data Mining (SDM'07), Minneapolis, MN, 2007", url="http://www.siam.org/proceedings/datamining/2007/dm07_037achtert.pdf")
public class COPAC<V extends NumberVector>
extends AbstractAlgorithm<Clustering<DimensionModel>>
implements ClusteringAlgorithm<Clustering<DimensionModel>> {
    private static final Logging LOG = Logging.getLogger(COPAC.class);
    Settings settings;

    public COPAC(Settings settings) {
        this.settings = settings;
    }

    public Clustering<DimensionModel> run(Database database, Relation<V> relation) {
        COPACNeighborPredicate.Instance instance = new COPACNeighborPredicate<V>(this.settings).instantiate(database, relation);
        CorePredicate.Instance instance2 = new MinPtsCorePredicate(this.settings.minpts).instantiate(database, TypeUtil.DBIDS);
        Clustering<Model> clustering = new GeneralizedDBSCAN.Instance<COPACNeighborPredicate.COPACModel>(instance, instance2, false).run();
        Clustering<DimensionModel> clustering2 = new Clustering<DimensionModel>("COPAC clustering", "copac-clustering");
        Hierarchy.Iter<Cluster<Model>> iter = clustering.iterToplevelClusters();
        while (iter.valid()) {
            Cluster<Model> cluster = iter.get();
            if (cluster.size() > 0) {
                int n = instance.dimensionality(cluster.getIDs().iter());
                DimensionModel dimensionModel = new DimensionModel(n);
                clustering2.addToplevelCluster(new Cluster<DimensionModel>(cluster.getIDs(), dimensionModel));
            }
            iter.advance();
        }
        return clustering2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(Settings.class);
        }

        @Override
        protected COPAC<V> makeInstance() {
            return new COPAC(this.settings);
        }
    }

    public static class Settings {
        public int k;
        public PCAFilteredRunner pca;
        public double epsilon;
        public int minpts;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID K_ID = new OptionID("copac.knn", "Number of neighbors to use for PCA.");
            Settings settings;

            @Override
            public void makeOptions(Parameterization parameterization) {
                this.settings = new Settings();
                this.configK(parameterization);
                this.settings.pca = parameterization.tryInstantiate(PCAFilteredRunner.class);
                this.configEpsilon(parameterization);
                this.configMinPts(parameterization);
            }

            protected void configK(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.k = intParameter.intValue();
                }
            }

            protected void configEpsilon(Parameterization parameterization) {
                DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.epsilon = doubleParameter.doubleValue();
                }
            }

            protected void configMinPts(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.minpts = intParameter.intValue();
                }
            }

            @Override
            public Settings makeInstance() {
                return this.settings;
            }
        }
    }
}

