/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.ERiCNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.GeneralizedDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FirstNEigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredRunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Title(value="ERiC: Exploring Relationships among Correlation Clusters")
@Description(value="Performs the DBSCAN algorithm on the data using a special distance function taking into account correlations among attributes and builds a hierarchy that allows multiple inheritance from the correlation clustering result.")
@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, and A. Zimek", title="On Exploring Complex Relationships of Correlation Clusters", booktitle="Proc. 19th International Conference on Scientific and Statistical Database Management (SSDBM 2007), Banff, Canada, 2007", url="http://dx.doi.org/10.1109/SSDBM.2007.21")
public class ERiC<V extends NumberVector>
extends AbstractAlgorithm<Clustering<CorrelationModel<V>>>
implements ClusteringAlgorithm<Clustering<CorrelationModel<V>>> {
    private static final Logging LOG = Logging.getLogger(ERiC.class);
    private Settings settings;

    public ERiC(Settings settings) {
        this.settings = settings;
    }

    public Clustering<CorrelationModel<V>> run(Database database, Relation<V> relation) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress(3) : null;
        LOG.beginStep(stepProgress, 1, "Preprocessing local correlation dimensionalities and partitioning data");
        ERiCNeighborPredicate.Instance instance = new ERiCNeighborPredicate<V>(this.settings).instantiate(database, relation);
        CorePredicate.Instance instance2 = new MinPtsCorePredicate(this.settings.minpts).instantiate(database, TypeUtil.DBIDS);
        Clustering<Model> clustering = new GeneralizedDBSCAN.Instance<DBIDs>(instance, instance2, false).run();
        LOG.beginStep(stepProgress, 2, "Extract correlation clusters");
        List<List<Cluster<CorrelationModel<V>>>> list = this.extractCorrelationClusters(clustering, relation, n, instance);
        if (LOG.isDebugging()) {
            object = new StringBuilder("Step 2: Extract correlation clusters...");
            for (int i = 0; i < list.size(); ++i) {
                List<Cluster<CorrelationModel<V>>> list2 = list.get(i);
                ((StringBuilder)object).append("\n\ncorrDim ").append(i);
                for (Cluster<CorrelationModel<V>> object2 : list2) {
                    ((StringBuilder)object).append("\n  cluster ").append(object2).append(", ids: ").append(object2.getIDs().size());
                }
            }
            LOG.debugFine(((StringBuilder)object).toString());
        }
        if (LOG.isVerbose()) {
            int n2 = 0;
            for (List<Cluster<CorrelationModel<V>>> list2 : list) {
                n2 += list2.size();
            }
            LOG.verbose(n2 + " clusters extracted.");
        }
        LOG.beginStep(stepProgress, 3, "Building hierarchy");
        object = new Clustering("ERiC clustering", "eric-clustering");
        this.buildHierarchy((Clustering<CorrelationModel<V>>)object, list, instance);
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder("Step 3: Build hierarchy");
            for (int i = 0; i < list.size(); ++i) {
                List<Cluster<CorrelationModel<V>>> list3 = list.get(i);
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    Cluster cluster = (Cluster)iterator.next();
                    stringBuilder.append("\n  cluster ").append(cluster).append(", ids: ").append(cluster.getIDs().size());
                    Hierarchy.Iter<Cluster> iter = ((Clustering)object).getClusterHierarchy().iterParents(cluster);
                    while (iter.valid()) {
                        stringBuilder.append("\n   parent ").append(iter.get());
                        iter.advance();
                    }
                    iter = ((Clustering)object).getClusterHierarchy().iterChildren(cluster);
                    while (iter.valid()) {
                        stringBuilder.append("\n   child ").append(iter.get());
                        iter.advance();
                    }
                }
            }
            LOG.debugFine(stringBuilder.toString());
        }
        LOG.setCompleted(stepProgress);
        for (Cluster<CorrelationModel<V>> cluster : list.get(list.size() - 1)) {
            ((Clustering)object).addToplevelCluster(cluster);
        }
        return object;
    }

    private List<List<Cluster<CorrelationModel<V>>>> extractCorrelationClusters(Clustering<Model> clustering, Relation<V> relation, int n, ERiCNeighborPredicate.Instance instance) {
        Cluster<CorrelationModel<V>> cluster;
        Object object;
        ArrayList<List<Cluster<CorrelationModel<V>>>> arrayList = new ArrayList<List<Cluster<CorrelationModel<V>>>>();
        for (int i = 0; i <= n; ++i) {
            arrayList.add(new ArrayList());
        }
        Cluster<Model> cluster2 = null;
        for (Cluster<Model> object2 : clustering.getAllClusters()) {
            int n2;
            object = object2.getIDs();
            int n3 = n2 = object2.isNoise() ? n : instance.dimensionality(object2.getIDs().iter());
            if (n2 < n) {
                cluster = new PCAFilteredRunner(new StandardCovarianceMatrixBuilder(), new FirstNEigenPairFilter(n2), 1.0, 0.0);
                List list = (List)arrayList.get(n2);
                PCAResult pCAResult = ((PCAFilteredRunner)((Object)cluster)).processIds((DBIDs)object, relation);
                V v = Centroid.make(relation, (DBIDs)object).toVector(relation);
                Cluster<CorrelationModel<V>> cluster3 = new Cluster<CorrelationModel<V>>("[" + n2 + "_" + list.size() + "]", (DBIDs)object, new CorrelationModel<V>((PCAFilteredResult)pCAResult, v));
                list.add(cluster3);
                continue;
            }
            if (cluster2 == null) {
                cluster2 = object2;
                continue;
            }
            cluster = DBIDUtil.newHashSet(cluster2.getIDs());
            cluster.addDBIDs(object2.getIDs());
            cluster2.setIDs((DBIDs)((Object)cluster));
        }
        if (cluster2 != null && cluster2.size() > 0) {
            List list = (List)arrayList.get(n);
            PCAFilteredRunner pCAFilteredRunner = new PCAFilteredRunner(new StandardCovarianceMatrixBuilder(), new FirstNEigenPairFilter(n), 1.0, 0.0);
            object = pCAFilteredRunner.processIds(cluster2.getIDs(), relation);
            V v = Centroid.make(relation, cluster2.getIDs()).toVector(relation);
            cluster = new Cluster<CorrelationModel<V>>("[noise]", cluster2.getIDs(), new CorrelationModel<V>((PCAFilteredResult)object, v));
            list.add(cluster);
        }
        for (int i = n; i > 0 && ((List)arrayList.get(i)).size() <= 0; --i) {
            arrayList.remove(i);
        }
        return arrayList;
    }

    private void buildHierarchy(Clustering<CorrelationModel<V>> clustering, List<List<Cluster<CorrelationModel<V>>>> list, ERiCNeighborPredicate.Instance instance) {
        StringBuilder stringBuilder = LOG.isDebuggingFine() ? new StringBuilder() : null;
        Hierarchy<Cluster<CorrelationModel<V>>> hierarchy = clustering.getClusterHierarchy();
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            List<Cluster<CorrelationModel<V>>> list2 = list.get(i);
            if (stringBuilder != null) {
                stringBuilder.append("\ncorrdim ").append(i);
            }
            for (Cluster<CorrelationModel<V>> cluster : list2) {
                for (int j = i + 1; j <= n; ++j) {
                    List<Cluster<CorrelationModel<V>>> list3 = list.get(j);
                    for (Cluster<CorrelationModel<V>> cluster2 : list3) {
                        int n2 = cluster2.getModel().getPCAResult().getCorrelationDimension();
                        if (n2 == n && hierarchy.numParents(cluster) == 0) {
                            clustering.addChildCluster(cluster2, cluster);
                            if (stringBuilder == null) continue;
                            stringBuilder.append('\n').append(cluster2).append(" is parent of ").append(cluster);
                            continue;
                        }
                        boolean bl = instance.weakNeighbors((NumberVector)cluster2.getModel().getCentroid(), (NumberVector)cluster.getModel().getCentroid(), cluster2.getModel().getPCAResult(), cluster.getModel().getPCAResult());
                        if (bl || hierarchy.numParents(cluster) != 0 && this.isParent(instance, cluster2, hierarchy.iterParents(cluster))) continue;
                        clustering.addChildCluster(cluster2, cluster);
                        if (stringBuilder == null) continue;
                        stringBuilder.append('\n').append(cluster2).append(" is parent of ").append(cluster);
                    }
                }
            }
        }
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
    }

    private boolean isParent(ERiCNeighborPredicate.Instance instance, Cluster<CorrelationModel<V>> cluster, Hierarchy.Iter<Cluster<CorrelationModel<V>>> iter) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = LOG.isDebugging() ? new StringBuilder() : null;
        while (iter.valid()) {
            Cluster<CorrelationModel<V>> cluster2 = iter.get();
            if (cluster.getModel().getPCAResult().getCorrelationDimension() == cluster2.getModel().getPCAResult().getCorrelationDimension()) {
                return false;
            }
            boolean bl = instance.weakNeighbors((NumberVector)cluster.getModel().getCentroid(), (NumberVector)cluster2.getModel().getCentroid(), cluster.getModel().getPCAResult(), cluster2.getModel().getPCAResult());
            if (stringBuilder != null) {
                stringBuilder.append("\ndist(").append(cluster2).append(" - ").append(cluster).append(") = ").append(bl);
            }
            if (bl) {
                if (stringBuilder != null) {
                    LOG.debugFine(stringBuilder);
                }
                return true;
            }
            iter.advance();
        }
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
        return false;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.settings = parameterization.tryInstantiate(Settings.class);
        }

        @Override
        protected ERiC<V> makeInstance() {
            return new ERiC(this.settings);
        }
    }

    public static class Settings {
        public int k;
        public PCAFilteredRunner pca;
        public double delta;
        public double tau;
        public int minpts;

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID K_ID = new OptionID("eric.k", "Number of neighbors to use for PCA.");
            public static final OptionID DELTA_ID = new OptionID("ericdf.delta", "Threshold for approximate linear dependency: the strong eigenvectors of q are approximately linear dependent from the strong eigenvectors p if the following condition holds for all stroneg eigenvectors q_i of q (lambda_q < lambda_p): q_i' * M^check_p * q_i <= delta^2.");
            public static final OptionID TAU_ID = new OptionID("ericdf.tau", "Threshold for the maximum distance between two approximately linear dependent subspaces of two objects p and q (lambda_q < lambda_p) before considering them as parallel.");
            Settings settings;

            @Override
            public void makeOptions(Parameterization parameterization) {
                this.settings = new Settings();
                this.configK(parameterization);
                this.settings.pca = parameterization.tryInstantiate(PCAFilteredRunner.class);
                this.configDelta(parameterization);
                this.configTau(parameterization);
                this.configMinPts(parameterization);
            }

            protected void configK(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.k = intParameter.intValue();
                }
            }

            protected void configDelta(Parameterization parameterization) {
                DoubleParameter doubleParameter = new DoubleParameter(DELTA_ID, 0.1);
                doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.delta = doubleParameter.doubleValue();
                }
            }

            protected void configTau(Parameterization parameterization) {
                DoubleParameter doubleParameter = new DoubleParameter(TAU_ID, 0.1);
                doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
                if (parameterization.grab(doubleParameter)) {
                    this.settings.tau = doubleParameter.doubleValue();
                }
            }

            protected void configMinPts(Parameterization parameterization) {
                IntParameter intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.settings.minpts = intParameter.intValue();
                }
            }

            @Override
            public Settings makeInstance() {
                return this.settings;
            }
        }
    }
}

