/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LUDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;

public class MultivariateGaussianModel
implements EMClusterModel<EMModel> {
    private static Logging LOG = Logging.getLogger(MultivariateGaussianModel.class);
    Vector mean;
    Matrix covariance;
    Matrix invCovMatr;
    double[] nmea;
    double[] mref;
    double[][] elements;
    double norm;
    double normDistrFactor;
    double weight;
    double wsum;

    public MultivariateGaussianModel(double d, Vector vector) {
        this(d, vector, MathUtil.powi(Math.PI * 2, vector.getDimensionality()));
    }

    public MultivariateGaussianModel(double d, Vector vector, double d2) {
        this.weight = d;
        int n = vector.getDimensionality();
        this.mean = vector;
        this.norm = d2;
        this.normDistrFactor = 1.0 / Math.sqrt(d2);
        this.mref = vector.getArrayRef();
        this.nmea = new double[n];
        this.covariance = new Matrix(n, n);
        this.elements = this.covariance.getArrayRef();
        this.wsum = 0.0;
    }

    @Override
    public void beginEStep() {
        if (this.covariance == null) {
            this.covariance = new Matrix(this.mean.getDimensionality(), this.mean.getDimensionality());
            return;
        }
        this.wsum = 0.0;
    }

    @Override
    public void updateE(NumberVector numberVector, double d) {
        int n;
        assert (numberVector.getDimensionality() == this.mref.length);
        double d2 = this.wsum + d;
        for (n = 0; n < this.mref.length; ++n) {
            double d3 = numberVector.doubleValue(n) - this.mref[n];
            double d4 = d3 * d / d2;
            this.nmea[n] = this.mref[n] + d4;
        }
        for (n = 0; n < this.mref.length; ++n) {
            for (int i = n; i < this.mref.length; ++i) {
                double d5 = (numberVector.doubleValue(n) - this.nmea[n]) * (numberVector.doubleValue(i) - this.mref[i]) * d;
                this.elements[n][i] = this.elements[n][i] + d5;
                if (n == i) continue;
                this.elements[i][n] = this.elements[i][n] + d5;
            }
        }
        this.wsum = d2;
        System.arraycopy(this.nmea, 0, this.mref, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep() {
        LUDecomposition lUDecomposition;
        double d;
        int n = this.mean.getDimensionality();
        if (this.wsum > Double.MIN_NORMAL) {
            this.covariance.timesEquals(1.0 / this.wsum);
        }
        if (!((d = (lUDecomposition = new LUDecomposition(this.covariance)).det()) > 0.0)) {
            this.covariance.plusDiagonalEquals(1.0E-9);
            lUDecomposition = new LUDecomposition(this.covariance);
            d = lUDecomposition.det();
            if (!(d > 0.0)) {
                LOG.warning("Singularity cheat did not resolve zero determinant.");
                d = 1.0;
            }
        }
        this.normDistrFactor = 1.0 / Math.sqrt(this.norm * d);
        this.invCovMatr = lUDecomposition.solve(Matrix.identity(n, n));
    }

    public double mahalanobisDistance(Vector vector) {
        if (this.invCovMatr != null) {
            return VMath.mahalanobisDistance(this.invCovMatr.getArrayRef(), vector.getArrayRef(), this.mref);
        }
        Vector vector2 = vector.minus(this.mean);
        return vector2.transposeTimes(vector2);
    }

    public double mahalanobisDistance(NumberVector numberVector) {
        Vector vector = numberVector.getColumnVector().minusEquals(this.mean);
        return this.invCovMatr != null ? vector.transposeTimesTimes(this.invCovMatr, vector) : vector.transposeTimes(vector);
    }

    @Override
    public double estimateDensity(NumberVector numberVector) {
        double d = this.mahalanobisDistance(numberVector) * 0.5;
        double d2 = this.normDistrFactor * Math.exp(-d);
        if (!(d2 >= 0.0)) {
            LOG.warning("Invalid probability: " + d2 + " power: " + d + " factor: " + this.normDistrFactor);
            d2 = 0.0;
        }
        return d2 * this.weight;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double d) {
        this.weight = d;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, this.covariance);
    }
}

