/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.AbstractEMModelFactory;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.SphericalGaussianModel;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.util.ArrayList;
import java.util.List;

public class SphericalGaussianModelFactory<V extends NumberVector>
extends AbstractEMModelFactory<V, EMModel> {
    public SphericalGaussianModelFactory(KMeansInitialization<V> kMeansInitialization) {
        super(kMeansInitialization);
    }

    @Override
    public List<SphericalGaussianModel> buildInitialModels(Database database, Relation<V> relation, int n, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction) {
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, n, numberVectorDistanceFunction, Vector.FACTORY);
        assert (list.size() == n);
        int n2 = list.get(0).getDimensionality();
        double d = MathUtil.powi(Math.PI * 2, n2);
        ArrayList<SphericalGaussianModel> arrayList = new ArrayList<SphericalGaussianModel>(n);
        for (Vector vector : list) {
            arrayList.add(new SphericalGaussianModel(1.0 / (double)n, vector, d));
        }
        return arrayList;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractEMModelFactory.Parameterizer<V> {
        @Override
        protected SphericalGaussianModelFactory<V> makeInstance() {
            return new SphericalGaussianModelFactory(this.initializer);
        }
    }
}

