/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.LinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.SingleLinkageMethod;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.WardLinkageMethod;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="L. Kaufman and P. J. Rousseeuw", title="Agglomerative Nesting (Program AGNES)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="http://dx.doi.org/10.1002/9780470316801.ch5")
@Alias(value={"HAC", "NaiveAgglomerativeHierarchicalClustering", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.NaiveAgglomerativeHierarchicalClustering"})
public class AGNES<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(AGNES.class);
    LinkageMethod linkage = WardLinkageMethod.STATIC;
    @Reference(authors="P. H. Sneath", title="The application of computers to taxonomy", booktitle="Journal of general microbiology, 17(1)", url="http://dx.doi.org/10.1099/00221287-17-1-201")
    public static final Void ADDITIONAL_REFERENCE = null;

    public AGNES(DistanceFunction<? super O> distanceFunction, LinkageMethod linkageMethod) {
        super(distanceFunction);
        this.linkage = linkageMethod;
    }

    public PointerHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        int n = arrayDBIDs.size();
        if (n > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~16 GB RAM), at which point the Java maximum array size is reached.");
        }
        if (SingleLinkageMethod.class.isInstance(this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        double[] dArray = new double[AGNES.triangleSize(n)];
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        boolean bl = WardLinkageMethod.class.isInstance(this.linkage) && !SquaredEuclideanDistanceFunction.class.isInstance(this.getDistanceFunction());
        AGNES.initializeDistanceMatrix(dArray, distanceQuery, dBIDArrayIter, dBIDArrayIter2, bl);
        PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder = new PointerHierarchyRepresentationBuilder(arrayDBIDs);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", n - 1, LOG) : null;
        int n2 = n;
        for (int i = 1; i < n; ++i) {
            int n3 = this.findMerge(n2, dArray, dBIDArrayIter, dBIDArrayIter2, pointerHierarchyRepresentationBuilder);
            if (n3 == n2 - 1) {
                dBIDArrayIter.seek(--n2 - 1);
                while (pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter)) {
                    --n2;
                    dBIDArrayIter.retract();
                }
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        return pointerHierarchyRepresentationBuilder.complete();
    }

    protected static int triangleSize(int n) {
        return n * (n - 1) >>> 1;
    }

    protected static <O> void initializeDistanceMatrix(double[] dArray, DistanceQuery<O> distanceQuery, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, boolean bl) {
        int n = 0;
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            dBIDArrayIter2.seek(0);
            while (dBIDArrayIter2.getOffset() < dBIDArrayIter.getOffset()) {
                double d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                dArray[n] = d = bl ? d * d : d;
                ++n;
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
    }

    protected int findMerge(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder) {
        double d = Double.POSITIVE_INFINITY;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            if (!pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n4))) {
                assert (n5 == AGNES.triangleSize(n4));
                for (int i = 0; i < n4; ++i) {
                    int n6;
                    if (pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter2.seek(i)) || !(dArray[n6 = n5 + i] <= d)) continue;
                    d = dArray[n6];
                    n2 = n4;
                    n3 = i;
                }
            }
            n5 += n4++;
        }
        assert (n2 >= 0 && n3 >= 0);
        this.merge(n, dArray, dBIDArrayIter, dBIDArrayIter2, pointerHierarchyRepresentationBuilder, d, n2, n3);
        return n2;
    }

    protected void merge(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder, double d, int n2, int n3) {
        dBIDArrayIter.seek(n2);
        dBIDArrayIter2.seek(n3);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(dBIDArrayIter) + " -> " + DBIDUtil.toString(dBIDArrayIter2) + " " + d);
        }
        assert (n3 < n2);
        pointerHierarchyRepresentationBuilder.add(dBIDArrayIter, d, dBIDArrayIter2);
        int n4 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
        int n5 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter2);
        pointerHierarchyRepresentationBuilder.setSize(dBIDArrayIter2, n4 + n5);
        this.updateMatrix(n, dArray, dBIDArrayIter2, pointerHierarchyRepresentationBuilder, d, n2, n3, n4, n5);
    }

    protected void updateMatrix(int n, double[] dArray, DBIDArrayIter dBIDArrayIter, PointerHierarchyRepresentationBuilder pointerHierarchyRepresentationBuilder, double d, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9 = AGNES.triangleSize(n2);
        int n10 = AGNES.triangleSize(n3);
        for (n8 = 0; n8 < n3; ++n8) {
            if (pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) continue;
            n7 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
            n6 = n10 + n8;
            dArray[n6] = this.linkage.combine(n4, dArray[n9 + n8], n5, dArray[n6], n7, d);
        }
        n7 = AGNES.triangleSize(++n8);
        while (n8 < n2) {
            if (!pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) {
                n6 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
                int n11 = n7 + n3;
                dArray[n11] = this.linkage.combine(n4, dArray[n9 + n8], n5, dArray[n11], n6, d);
            }
            n7 += n8++;
        }
        n7 += n8++;
        while (n8 < n) {
            if (!pointerHierarchyRepresentationBuilder.isLinked(dBIDArrayIter.seek(n8))) {
                n6 = pointerHierarchyRepresentationBuilder.getSize(dBIDArrayIter);
                dArray[n7 + n3] = this.linkage.combine(n4, dArray[n7 + n2], n5, dArray[n7 + n3], n6, d);
            }
            n7 += n8++;
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID LINKAGE_ID = new OptionID("hierarchical.linkage", "Linkage method to use (e.g. Ward, Single-Link)");
        protected LinkageMethod linkage;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(SquaredEuclideanDistanceFunction.class, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            ObjectParameter objectParameter2 = new ObjectParameter(LINKAGE_ID, LinkageMethod.class);
            objectParameter2.setDefaultValue(WardLinkageMethod.class);
            if (parameterization.grab(objectParameter2)) {
                this.linkage = (LinkageMethod)objectParameter2.instantiateClass(parameterization);
            }
        }

        @Override
        protected AGNES<O> makeInstance() {
            return new AGNES(this.distanceFunction, this.linkage);
        }
    }
}

