/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.RandomlyGeneratedInitialMeans"})
public class RandomlyGeneratedInitialMeans
extends AbstractKMeansInitialization<NumberVector> {
    public RandomlyGeneratedInitialMeans(RandomFactory randomFactory) {
        super(randomFactory);
    }

    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        int n2 = RelationUtil.dimensionality(relation);
        double[][] dArray = RelationUtil.computeMinMax(relation);
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = dArray3[i] - dArray2[i];
        }
        ArrayList<V> arrayList = new ArrayList<V>(n);
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = MathUtil.randomDoubleArray(n2, random);
            for (int j = 0; j < n2; ++j) {
                dArray4[j] = dArray2[j] + dArray3[j] * dArray4[j];
            }
            arrayList.add(factory.newNumberVector(dArray4));
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected RandomlyGeneratedInitialMeans makeInstance() {
            return new RandomlyGeneratedInitialMeans(this.rnd);
        }
    }
}

