/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.optics;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;

public class ClusterOrder
extends BasicResult
implements OrderingResult {
    ArrayModifiableDBIDs ids;
    WritableDoubleDataStore reachability;
    WritableDBIDDataStore predecessor;

    public ClusterOrder(DBIDs dBIDs, String string, String string2) {
        super(string, string2);
        this.ids = DBIDUtil.newArray(dBIDs.size());
        this.reachability = DataStoreUtil.makeDoubleStorage(dBIDs, 30, Double.POSITIVE_INFINITY);
        this.predecessor = DataStoreUtil.makeDBIDStorage(dBIDs, 2);
        this.addChildResult(new MaterializedDoubleRelation("Reachability distance", "reachdist", this.reachability, dBIDs));
        this.addChildResult(new MaterializedRelation<DBID>("OPTICS predecessor", "predecessor", TypeUtil.DBID, this.predecessor, dBIDs));
    }

    public ClusterOrder(String string, String string2, ArrayModifiableDBIDs arrayModifiableDBIDs, WritableDoubleDataStore writableDoubleDataStore, WritableDBIDDataStore writableDBIDDataStore) {
        super(string, string2);
        this.ids = arrayModifiableDBIDs;
        this.reachability = writableDoubleDataStore;
        this.predecessor = writableDBIDDataStore;
        this.addChildResult(new MaterializedDoubleRelation("Reachability distance", "reachdist", writableDoubleDataStore, arrayModifiableDBIDs));
        if (writableDBIDDataStore != null) {
            this.addChildResult(new MaterializedRelation<DBID>("OPTICS predecessor", "predecessor", TypeUtil.DBID, writableDBIDDataStore, arrayModifiableDBIDs));
        }
    }

    public void add(DBIDRef dBIDRef, double d, DBIDRef dBIDRef2) {
        this.ids.add(dBIDRef);
        this.reachability.putDouble(dBIDRef, d);
        if (dBIDRef2 == null || dBIDRef2 instanceof DBIDVar && !((DBIDVar)dBIDRef2).isSet()) {
            return;
        }
        this.predecessor.putDBID(dBIDRef, dBIDRef2);
    }

    @Override
    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDArrayIter iter() {
        return this.ids.iter();
    }

    @Override
    public ArrayModifiableDBIDs order(DBIDs dBIDs) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs.size());
        DBIDArrayMIter dBIDArrayMIter = this.ids.iter();
        while (dBIDArrayMIter.valid()) {
            if (dBIDs.contains(dBIDArrayMIter)) {
                arrayModifiableDBIDs.add(dBIDArrayMIter);
            }
            dBIDArrayMIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    public int size() {
        return this.ids.size();
    }

    public double getReachability(DBIDRef dBIDRef) {
        return this.reachability.doubleValue(dBIDRef);
    }

    public void getPredecessor(DBIDRef dBIDRef, DBIDVar dBIDVar) {
        if (this.predecessor == null) {
            dBIDVar.unset();
            return;
        }
        this.predecessor.assignVar(dBIDRef, dBIDVar);
    }
}

