/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Trivial all-noise clustering")
@Description(value="Returns a 'trivial' clustering which just considers all points as noise points.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.TrivialAllNoise"})
public class TrivialAllNoise
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(TrivialAllNoise.class);

    public Clustering<Model> run(Relation<?> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        Clustering<Model> clustering = new Clustering<Model>("All-in-noise trivial Clustering", "allinnoise-clustering");
        Cluster<ClusterModel> cluster = new Cluster<ClusterModel>(dBIDs, true, ClusterModel.CLUSTER);
        clustering.addToplevelCluster(cluster);
        return clustering;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

