/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;

@Reference(authors="Erich Schubert, Alexander Koos, Tobias Emrich, Andreas Z\u00fcfle, Klaus Arthur Schmid, Arthur Zimek", title="A Framework for Clustering Uncertain Data", booktitle="Proceedings of the VLDB Endowment, 8(12)", url="http://www.vldb.org/pvldb/vol8/p1976-schubert.pdf")
public class CenterOfMassMetaClustering<C extends Clustering<?>>
extends AbstractAlgorithm<C>
implements ClusteringAlgorithm<C> {
    private static final Logging LOG = Logging.getLogger(CenterOfMassMetaClustering.class);
    protected ClusteringAlgorithm<C> inner;

    public CenterOfMassMetaClustering(ClusteringAlgorithm<C> clusteringAlgorithm) {
        this.inner = clusteringAlgorithm;
    }

    public C run(Database database, Relation<? extends UncertainObject> relation) {
        int n = RelationUtil.dimensionality(relation);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDataStore<DoubleVector> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 30, DoubleVector.class);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            writableDataStore.put(dBIDIter, relation.get(dBIDIter).getCenterOfMass());
            dBIDIter.advance();
        }
        return this.runClusteringAlgorithm(database.getHierarchy(), relation, dBIDs, writableDataStore, n, "Uncertain Model: Center of Mass");
    }

    protected C runClusteringAlgorithm(ResultHierarchy resultHierarchy, Result result, DBIDs dBIDs, DataStore<DoubleVector> dataStore, int n, String string) {
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n);
        MaterializedRelation<DoubleVector> materializedRelation = new MaterializedRelation<DoubleVector>(vectorFieldTypeInformation, dBIDs, string, dataStore);
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs, materializedRelation);
        C c = this.inner.run(proxyDatabase);
        proxyDatabase.getHierarchy().remove(materializedRelation);
        proxyDatabase.getHierarchy().remove(c);
        resultHierarchy.add(result, materializedRelation);
        resultHierarchy.add(materializedRelation, (Result)c);
        return c;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.UNCERTAIN_OBJECT_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<C extends Clustering<?>>
    extends AbstractParameterizer {
        protected ClusteringAlgorithm<C> inner;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, ClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.inner = (ClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
                if (this.inner != null && this.inner.getInputTypeRestriction().length > 0 && !this.inner.getInputTypeRestriction()[0].isAssignableFromType(TypeUtil.NUMBER_VECTOR_FIELD)) {
                    parameterization.reportError(new WrongParameterValueException(objectParameter, objectParameter.getValueAsString(), "The inner clustering algorithm (as configured) does not accept numerical vectors: " + this.inner.getInputTypeRestriction()[0]));
                }
            }
        }

        @Override
        protected CenterOfMassMetaClustering<C> makeInstance() {
            return new CenterOfMassMetaClustering<C>(this.inner);
        }
    }
}

