/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;

public class TrivialAverageCoordinateOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging logger = Logging.getLogger(TrivialAverageCoordinateOutlier.class);

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH);
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        Object object;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Mean mean = new Mean();
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            mean.reset();
            object = relation.get((DBIDRef)object2);
            for (int i = 0; i < object.getDimensionality(); ++i) {
                mean.put(object.doubleValue(i));
            }
            double d = mean.getMean();
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            doubleMinMax.put(d);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("Trivial mean score", "mean-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax());
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    protected Logging getLogger() {
        return logger;
    }
}

