/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.HashSet;

public class TrivialGeneratedOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(TrivialGeneratedOutlier.class);
    double expect = 0.01;

    public TrivialGeneratedOutlier(double d) {
        this.expect = d;
    }

    public TrivialGeneratedOutlier() {
        this(0.01);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD, new SimpleTypeInformation<Model>(Model.class), TypeUtil.GUESSED_LABEL);
    }

    @Override
    public OutlierResult run(Database database) {
        Relation<NumberVector> relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<Model> relation2 = database.getRelation(new SimpleTypeInformation<Model>(Model.class), new Object[0]);
        try {
            Relation relation3 = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(relation2, relation, relation3);
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            return this.run(relation2, relation, database.getRelation(TypeUtil.GUESSED_LABEL, new Object[0]));
        }
    }

    public OutlierResult run(Relation<Model> relation, Relation<NumberVector> relation2, Relation<?> relation3) {
        Object object;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        HashSet<GeneratorSingleCluster> hashSet = new HashSet<GeneratorSingleCluster>();
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            Model model = relation.get((DBIDRef)object2);
            if (model instanceof GeneratorSingleCluster) {
                hashSet.add((GeneratorSingleCluster)model);
            }
            object2.advance();
        }
        if (hashSet.size() == 0) {
            LOG.warning("No generator models found for dataset - all points will be considered outliers.");
        }
        for (GeneratorSingleCluster probabilisticOutlierScore : hashSet) {
            for (int i = 0; i < probabilisticOutlierScore.getDim(); ++i) {
                object = probabilisticOutlierScore.getDistribution(i);
                if (object instanceof NormalDistribution) continue;
                throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + object);
            }
        }
        object2 = relation.iterDBIDs();
        while (object2.valid()) {
            double d = 1.0;
            object = relation2.get((DBIDRef)object2).getColumnVector();
            for (GeneratorSingleCluster generatorSingleCluster : hashSet) {
                Object object3 = object;
                if (generatorSingleCluster.getTransformation() != null) {
                    object3 = generatorSingleCluster.getTransformation().applyInverse((Vector)object);
                }
                int n = ((Vector)object3).getDimensionality();
                double d2 = 0.0;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Distribution distribution = generatorSingleCluster.getDistribution(i);
                    if (distribution instanceof NormalDistribution) {
                        NormalDistribution normalDistribution = (NormalDistribution)distribution;
                        double d3 = (((Vector)object3).get(i) - normalDistribution.getMean()) / normalDistribution.getStddev();
                        d2 += d3 * d3;
                        ++n2;
                        continue;
                    }
                    throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + distribution);
                }
                if ((double)n2 > 0.0) {
                    d = Math.min(d, ChiSquaredDistribution.cdf(d2, n2));
                    continue;
                }
                d = 0.0;
            }
            if (this.expect < 1.0) {
                d = this.expect * d / (1.0 - d + this.expect);
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("Model outlier scores", "model-outlier", writableDoubleDataStore, relation.getDBIDs());
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore(0.0, 1.0);
        return new OutlierResult(probabilisticOutlierScore, (DoubleRelation)object2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EXPECT_ID = new OptionID("modeloutlier.expect", "Expected amount of outliers, for making the scores more intuitive. When the value is 1, the CDF will be given instead.");
        double expect;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(EXPECT_ID, 0.01);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.expect = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected TrivialGeneratedOutlier makeInstance() {
            return new TrivialGeneratedOutlier(this.expect);
        }
    }
}

