/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import java.util.ArrayList;
import java.util.List;

public class DatabaseEventManager {
    private List<DataStoreListener> dataListenerList = new ArrayList<DataStoreListener>();
    private List<ResultListener> resultListenerList = new ArrayList<ResultListener>();
    private boolean accumulateDataStoreEvents = false;
    private Type currentDataStoreEventType = null;
    private HashSetModifiableDBIDs dataStoreObjects;

    public void accumulateDataStoreEvents() {
        this.accumulateDataStoreEvents = true;
    }

    public void flushDataStoreEvents() {
        DataStoreEvent dataStoreEvent;
        switch (this.currentDataStoreEventType) {
            case INSERT: {
                dataStoreEvent = DataStoreEvent.insertionEvent(this.dataStoreObjects);
                break;
            }
            case REMOVE: {
                dataStoreEvent = DataStoreEvent.removalEvent(this.dataStoreObjects);
                break;
            }
            case UPDATE: {
                dataStoreEvent = DataStoreEvent.updateEvent(this.dataStoreObjects);
                break;
            }
            default: {
                return;
            }
        }
        int n = this.dataListenerList.size();
        while (--n >= 0) {
            this.dataListenerList.get(n).contentChanged(dataStoreEvent);
        }
        this.accumulateDataStoreEvents = false;
        this.currentDataStoreEventType = null;
        this.dataStoreObjects = null;
    }

    public void addListener(DataStoreListener dataStoreListener) {
        this.dataListenerList.add(dataStoreListener);
    }

    public void removeListener(DataStoreListener dataStoreListener) {
        this.dataListenerList.remove(dataStoreListener);
    }

    public void addListener(ResultListener resultListener) {
        this.resultListenerList.add(resultListener);
    }

    public void removeListener(ResultListener resultListener) {
        this.resultListenerList.remove(resultListener);
    }

    public void fireObjectsInserted(DBIDs dBIDs) {
        this.fireObjectsChanged(dBIDs, Type.INSERT);
    }

    public void fireObjectInserted(DBIDRef dBIDRef) {
        this.fireObjectChanged(dBIDRef, Type.INSERT);
    }

    public void fireObjectsUpdated(DBIDs dBIDs) {
        this.fireObjectsChanged(dBIDs, Type.UPDATE);
    }

    public void fireObjectsUpdated(DBIDRef dBIDRef) {
        this.fireObjectChanged(dBIDRef, Type.UPDATE);
    }

    protected void fireObjectsRemoved(DBIDs dBIDs) {
        this.fireObjectsChanged(dBIDs, Type.REMOVE);
    }

    protected void fireObjectRemoved(DBIDRef dBIDRef) {
        this.fireObjectChanged(dBIDRef, Type.REMOVE);
    }

    private void fireObjectsChanged(DBIDs dBIDs, Type type) {
        DataStoreEvent dataStoreEvent;
        if (this.currentDataStoreEventType != null && !this.currentDataStoreEventType.equals((Object)type)) {
            this.flushDataStoreEvents();
        }
        if (this.accumulateDataStoreEvents) {
            if (this.dataStoreObjects == null) {
                this.dataStoreObjects = DBIDUtil.newHashSet();
            }
            this.dataStoreObjects.addDBIDs(dBIDs);
            this.currentDataStoreEventType = type;
            return;
        }
        switch (type) {
            case INSERT: {
                dataStoreEvent = DataStoreEvent.insertionEvent(dBIDs);
                break;
            }
            case REMOVE: {
                dataStoreEvent = DataStoreEvent.removalEvent(dBIDs);
                break;
            }
            case UPDATE: {
                dataStoreEvent = DataStoreEvent.updateEvent(dBIDs);
                break;
            }
            default: {
                return;
            }
        }
        int n = this.dataListenerList.size();
        while (--n >= 0) {
            this.dataListenerList.get(n).contentChanged(dataStoreEvent);
        }
    }

    private void fireObjectChanged(DBIDRef dBIDRef, Type type) {
        if (this.currentDataStoreEventType != null && !this.currentDataStoreEventType.equals((Object)type)) {
            this.flushDataStoreEvents();
        }
        if (this.dataStoreObjects == null) {
            this.dataStoreObjects = DBIDUtil.newHashSet();
        }
        this.dataStoreObjects.add(dBIDRef);
        this.currentDataStoreEventType = type;
        if (!this.accumulateDataStoreEvents) {
            this.flushDataStoreEvents();
        }
    }

    public void fireResultAdded(Result result, Result result2) {
        int n = this.resultListenerList.size();
        while (--n >= 0) {
            this.resultListenerList.get(n).resultAdded(result, result2);
        }
    }

    public void fireResultRemoved(Result result, Result result2) {
        int n = this.resultListenerList.size();
        while (--n >= 0) {
            this.resultListenerList.get(n).resultRemoved(result, result2);
        }
    }

    private static enum Type {
        INSERT,
        REMOVE,
        UPDATE;

    }
}

