/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanEuclideanDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.LinearScanPrimitiveDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanEuclideanDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanPrimitiveDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;

public final class QueryUtil {
    public static <O> DistanceQuery<O> getDistanceQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        Relation relation = database.getRelation(distanceFunction.getInputTypeRestriction(), objectArray);
        return database.getDistanceQuery(relation, distanceFunction, objectArray);
    }

    public static <O> SimilarityQuery<O> getSimilarityQuery(Database database, SimilarityFunction<? super O> similarityFunction, Object ... objectArray) {
        Relation relation = database.getRelation(similarityFunction.getInputTypeRestriction(), objectArray);
        return database.getSimilarityQuery(relation, similarityFunction, objectArray);
    }

    public static <O> KNNQuery<O> getKNNQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        Relation<Object> relation = database.getRelation(distanceFunction.getInputTypeRestriction(), objectArray);
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, objectArray);
        return relation.getKNNQuery(distanceQuery, objectArray);
    }

    public static <O> KNNQuery<O> getKNNQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, objectArray);
        return relation.getKNNQuery(distanceQuery, objectArray);
    }

    public static <O> RangeQuery<O> getRangeQuery(Database database, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        Relation<Object> relation = database.getRelation(distanceFunction.getInputTypeRestriction(), objectArray);
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, objectArray);
        return relation.getRangeQuery(distanceQuery, objectArray);
    }

    public static <O> RangeQuery<O> getRangeQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, objectArray);
        return relation.getRangeQuery(distanceQuery, objectArray);
    }

    public static <O> RKNNQuery<O> getRKNNQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        DistanceQuery<? super O> distanceQuery = relation.getDistanceQuery(distanceFunction, objectArray);
        return relation.getRKNNQuery(distanceQuery, objectArray);
    }

    public static <O> KNNQuery<O> getLinearScanKNNQuery(DistanceQuery<O> distanceQuery) {
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery primitiveDistanceQuery = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistanceFunction.STATIC.equals(primitiveDistanceQuery.getDistanceFunction())) {
                PrimitiveDistanceQuery primitiveDistanceQuery2 = primitiveDistanceQuery;
                return new LinearScanEuclideanDistanceKNNQuery(primitiveDistanceQuery2);
            }
            return new LinearScanPrimitiveDistanceKNNQuery(primitiveDistanceQuery);
        }
        return new LinearScanDistanceKNNQuery<O>(distanceQuery);
    }

    public static <O> RangeQuery<O> getLinearScanRangeQuery(DistanceQuery<O> distanceQuery) {
        if (distanceQuery instanceof PrimitiveDistanceQuery) {
            PrimitiveDistanceQuery primitiveDistanceQuery = (PrimitiveDistanceQuery)distanceQuery;
            if (EuclideanDistanceFunction.STATIC.equals(primitiveDistanceQuery.getDistanceFunction())) {
                PrimitiveDistanceQuery primitiveDistanceQuery2 = primitiveDistanceQuery;
                return new LinearScanEuclideanDistanceRangeQuery(primitiveDistanceQuery2);
            }
            return new LinearScanPrimitiveDistanceRangeQuery(primitiveDistanceQuery);
        }
        return new LinearScanDistanceRangeQuery<O>(distanceQuery);
    }

    public static KNNList applySqrt(KNNList kNNList) {
        DoubleIntegerDBIDKNNList doubleIntegerDBIDKNNList = new DoubleIntegerDBIDKNNList(kNNList.getK(), kNNList.size());
        DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
        while (doubleDBIDListIter.valid()) {
            doubleIntegerDBIDKNNList.add(Math.sqrt(doubleDBIDListIter.doubleValue()), doubleDBIDListIter);
            doubleDBIDListIter.advance();
        }
        return doubleIntegerDBIDKNNList;
    }
}

