/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.AbstractIntegerDBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class SimpleDBIDFactory
extends AbstractIntegerDBIDFactory {
    int dynamicids = 0;
    int rangestart = 0;

    @Override
    public synchronized DBID generateSingleDBID() {
        --this.dynamicids;
        if (this.dynamicids == Integer.MIN_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        return new IntegerDBID(this.dynamicids);
    }

    @Override
    public void deallocateSingleDBID(DBIDRef dBIDRef) {
    }

    @Override
    public synchronized DBIDRange generateStaticDBIDRange(int n) {
        if (this.rangestart >= Integer.MAX_VALUE - n) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange integerDBIDRange = new IntegerDBIDRange(this.rangestart, n);
        this.rangestart += n;
        return integerDBIDRange;
    }

    @Override
    public DBIDRange generateStaticDBIDRange(int n, int n2) {
        if (n + n2 >= Integer.MAX_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange integerDBIDRange = new IntegerDBIDRange(n, n2);
        this.rangestart = Math.max(this.rangestart, n + n2);
        return integerDBIDRange;
    }

    @Override
    public void deallocateDBIDRange(DBIDRange dBIDRange) {
    }
}

