/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import java.util.ArrayList;
import java.util.List;

public class LinearScanPrimitiveDistanceKNNQuery<O>
extends AbstractDistanceKNNQuery<O>
implements LinearScanQuery {
    private PrimitiveDistanceFunction<? super O> rawdist;

    public LinearScanPrimitiveDistanceKNNQuery(PrimitiveDistanceQuery<O> primitiveDistanceQuery) {
        super(primitiveDistanceQuery);
        this.rawdist = primitiveDistanceQuery.getDistanceFunction();
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
        return this.linearScan(this.relation, this.relation.iterDBIDs(), this.relation.get(dBIDRef), DBIDUtil.newHeap(n)).toKNNList();
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        return this.linearScan(this.relation, this.relation.iterDBIDs(), o, DBIDUtil.newHeap(n)).toKNNList();
    }

    private KNNHeap linearScan(Relation<? extends O> relation, DBIDIter dBIDIter, O o, KNNHeap kNNHeap) {
        double d = Double.POSITIVE_INFINITY;
        while (dBIDIter.valid()) {
            double d2 = this.rawdist.distance(o, relation.get(dBIDIter));
            if (d2 <= d) {
                d = kNNHeap.insert(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
        return kNNHeap;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        int n2 = arrayDBIDs.size();
        ArrayList<KNNHeap> arrayList = new ArrayList<KNNHeap>(n2);
        ArrayList arrayList2 = new ArrayList(n2);
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            arrayList.add(DBIDUtil.newHeap(n));
            arrayList2.add(this.relation.get((DBIDRef)object));
            object.advance();
        }
        this.linearScanBatchKNN(arrayList2, arrayList);
        object = new ArrayList(arrayList.size());
        for (KNNHeap kNNHeap : arrayList) {
            object.add(kNNHeap.toKNNList());
        }
        return object;
    }

    protected void linearScanBatchKNN(List<O> list, List<KNNHeap> list2) {
        int n = list.size();
        DBIDIter dBIDIter = this.relation.getDBIDs().iter();
        while (dBIDIter.valid()) {
            Object o = this.relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                KNNHeap kNNHeap = list2.get(i);
                double d = this.rawdist.distance(list.get(i), o);
                if (!(d <= kNNHeap.getKNNDistance())) continue;
                kNNHeap.insert(d, dBIDIter);
            }
            dBIDIter.advance();
        }
    }
}

