/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.InputStream;
import java.util.List;

@Title(value="Input-Stream based database connection")
@Description(value="Parse an input stream such as STDIN into a database.")
public class InputStreamDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(InputStreamDatabaseConnection.class);
    Parser parser;
    InputStream in = System.in;

    public InputStreamDatabaseConnection(List<ObjectFilter> list, Parser parser) {
        super(list);
        this.parser = parser;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        if (LOG.isDebugging()) {
            LOG.debugFine("Invoking parsers.");
        }
        if (this.parser instanceof StreamingParser) {
            StreamingParser streamingParser = (StreamingParser)this.parser;
            streamingParser.initStream(this.in);
            if (LOG.isDebugging()) {
                LOG.debugFine("Parsing as stream.");
            }
            Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".load").begin() : null;
            MultipleObjectsBundle multipleObjectsBundle = this.invokeStreamFilters(streamingParser).asMultipleObjectsBundle();
            this.parser.cleanup();
            if (duration != null) {
                LOG.statistics(duration.end());
            }
            return multipleObjectsBundle;
        }
        Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".parse").begin() : null;
        MultipleObjectsBundle multipleObjectsBundle = this.parser.parse(this.in);
        this.parser.cleanup();
        if (duration != null) {
            LOG.statistics(duration.end());
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("Invoking filters.");
        }
        Duration duration2 = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".filter").begin() : null;
        MultipleObjectsBundle multipleObjectsBundle2 = this.invokeBundleFilters(multipleObjectsBundle);
        if (duration2 != null) {
            LOG.statistics(duration2.end());
        }
        return multipleObjectsBundle2;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.configParser(parameterization, Parser.class, NumberVectorLabelParser.class);
            this.configFilters(parameterization);
        }

        @Override
        protected InputStreamDatabaseConnection makeInstance() {
            return new InputStreamDatabaseConnection(this.filters, this.parser);
        }
    }
}

