/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.ExternalIDJoinDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class LabelJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(LabelJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public LabelJoinDatabaseConnection(List<ObjectFilter> list, List<DatabaseConnection> list2) {
        super(list);
        this.sources = list2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        int n;
        Object object;
        int n2;
        int multipleObjectsBundle2;
        ArrayList<MultipleObjectsBundle> arrayList = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection object22 : this.sources) {
            arrayList.add(object22.loadData());
        }
        MultipleObjectsBundle multipleObjectsBundle = (MultipleObjectsBundle)arrayList.get(0);
        TObjectIntHashMap<String> tObjectIntHashMap = new TObjectIntHashMap<String>(multipleObjectsBundle.dataLength(), 0.5f, -1);
        int n3 = FilterUtil.findLabelColumn(multipleObjectsBundle);
        if (n3 == -1) {
            throw new AbortException("No label column found in first source, cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
        }
        for (multipleObjectsBundle2 = 0; multipleObjectsBundle2 < multipleObjectsBundle.dataLength(); ++multipleObjectsBundle2) {
            Object n6 = multipleObjectsBundle.data(multipleObjectsBundle2, n3);
            if (n6 == null) {
                LOG.warning("Object without label encountered.");
                continue;
            }
            if (n6 instanceof String) {
                int labelList = tObjectIntHashMap.put((String)n6, multipleObjectsBundle2);
                if (labelList == -1) continue;
                LOG.warning("Duplicate label encountered: " + n6 + " in rows " + labelList + " and " + multipleObjectsBundle2);
                continue;
            }
            if (n6 instanceof LabelList) {
                LabelList string = (LabelList)n6;
                for (n2 = 0; n2 < string.size(); ++n2) {
                    object = string.get(n2);
                    n = tObjectIntHashMap.put((String)object, multipleObjectsBundle2);
                    if (n == -1) continue;
                    LOG.warning("Duplicate label encountered: " + (String)object + " in rows " + n + " and " + multipleObjectsBundle2);
                }
                continue;
            }
            String arrayList2 = n6.toString();
            n2 = tObjectIntHashMap.put(arrayList2, multipleObjectsBundle2);
            if (n2 == -1) continue;
            LOG.warning("Duplicate label encountered: " + arrayList2 + " in rows " + n2 + " and " + multipleObjectsBundle2);
        }
        for (n3 = 1; n3 < this.sources.size(); ++n3) {
            MultipleObjectsBundle multipleObjectsBundle3 = (MultipleObjectsBundle)arrayList.get(n3);
            int stringBuilder = FilterUtil.findLabelColumn(multipleObjectsBundle3);
            if (stringBuilder == -1) {
                throw new AbortException("No label column found in source " + (n3 + 1) + ", cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
            }
            ArrayList<Object> i = new ArrayList<Object>(multipleObjectsBundle3.metaLength());
            for (n2 = 0; n2 < multipleObjectsBundle3.metaLength(); ++n2) {
                if (n2 == stringBuilder) {
                    i.add(null);
                    continue;
                }
                object = new ArrayList(multipleObjectsBundle.dataLength());
                for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
                    ((ArrayList)object).add(null);
                }
                multipleObjectsBundle.appendColumn(multipleObjectsBundle3.meta(n2), (List<?>)object);
                i.add(object);
            }
            for (n2 = 0; n2 < multipleObjectsBundle3.dataLength(); ++n2) {
                object = multipleObjectsBundle3.data(n2, stringBuilder);
                if (object == null) {
                    LOG.warning("Object without label encountered.");
                    continue;
                }
                n = -1;
                if (object instanceof String) {
                    n = tObjectIntHashMap.get(object);
                } else if (object instanceof LabelList) {
                    LabelList i2 = (LabelList)object;
                    for (int list = 0; list < i2.size() && (n = tObjectIntHashMap.get(i2.get(list))) < 0; ++list) {
                    }
                } else {
                    n = tObjectIntHashMap.get(object.toString());
                }
                if (n < 0) {
                    LOG.warning("Label not found for join: " + object + " in row " + n2);
                    continue;
                }
                for (int j = 0; j < multipleObjectsBundle3.metaLength(); ++j) {
                    if (j == stringBuilder) continue;
                    List list = (List)i.get(j);
                    assert (list != null);
                    list.set(n, multipleObjectsBundle3.data(n2, j));
                }
            }
        }
        block9: for (n3 = 0; n3 < multipleObjectsBundle.dataLength(); ++n3) {
            for (multipleObjectsBundle2 = 0; multipleObjectsBundle2 < multipleObjectsBundle.metaLength(); ++multipleObjectsBundle2) {
                if (multipleObjectsBundle.data(n3, multipleObjectsBundle2) != null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    if (multipleObjectsBundle.data(n3, i) == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    stringBuilder.append(multipleObjectsBundle.data(n3, i));
                }
                LOG.warning("null value in joined data, row " + n3 + " column " + multipleObjectsBundle2 + FormatUtil.NEWLINE + "[" + stringBuilder.toString() + "]");
                continue block9;
            }
        }
        return multipleObjectsBundle;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            super.configFilters(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (parameterization.grab(objectListParameter)) {
                this.sources = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected LabelJoinDatabaseConnection makeInstance() {
            return new LabelJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

