/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.List;

@Description(value="Blindly joins multiple data sources, assuming they are ordered the same way.")
public class PresortedBlindJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(PresortedBlindJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public PresortedBlindJoinDatabaseConnection(List<ObjectFilter> list, List<DatabaseConnection> list2) {
        super(list);
        this.sources = list2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        ArrayList<MultipleObjectsBundle> arrayList = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection : this.sources) {
            arrayList.add(databaseConnection.loadData());
        }
        MultipleObjectsBundle multipleObjectsBundle = (MultipleObjectsBundle)arrayList.get(0);
        for (int i = 1; i < this.sources.size(); ++i) {
            MultipleObjectsBundle multipleObjectsBundle2 = (MultipleObjectsBundle)arrayList.get(i);
            if (multipleObjectsBundle2.dataLength() != multipleObjectsBundle.dataLength()) {
                throw new AbortException("Data set sizes do not agree - cannot join!");
            }
            for (int j = 0; j < multipleObjectsBundle2.metaLength(); ++j) {
                multipleObjectsBundle.appendColumn(multipleObjectsBundle2.meta(j), multipleObjectsBundle2.getColumn(j));
            }
        }
        return this.invokeBundleFilters(multipleObjectsBundle);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            super.configFilters(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (parameterization.grab(objectListParameter)) {
                this.sources = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected PresortedBlindJoinDatabaseConnection makeInstance() {
            return new PresortedBlindJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

