/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;

public class MatrixWeightedDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    protected Matrix weightMatrix;

    public MatrixWeightedDistanceFunction(Matrix matrix) {
        this.weightMatrix = matrix;
        assert (matrix.getColumnDimensionality() == matrix.getRowDimensionality());
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        MatrixWeightedDistanceFunction.dimensionality(numberVector, numberVector2, this.weightMatrix.getColumnDimensionality());
        Vector vector = numberVector.getColumnVector().minusEquals(numberVector2.getColumnVector());
        return MathUtil.mahalanobisDistance(this.weightMatrix, vector);
    }

    @Override
    public VectorFieldTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, this.weightMatrix.getColumnDimensionality(), this.weightMatrix.getColumnDimensionality());
    }
}

