/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialNorm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPIntegerNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.MaximumDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Alias(value={"lp", "minkowski", "p", "de.lmu.ifi.dbs.elki.distance.distancefunction.LPNormDistanceFunction"})
public class LPNormDistanceFunction
extends AbstractSpatialNorm {
    protected double p;
    protected double invp;

    public LPNormDistanceFunction(double d) {
        this.p = d;
        this.invp = 1.0 / d;
    }

    private final double preDistance(NumberVector numberVector, NumberVector numberVector2, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2;
            double d3 = numberVector.doubleValue(i);
            double d4 = d3 >= (d2 = numberVector2.doubleValue(i)) ? d3 - d2 : d2 - d3;
            d += Math.pow(d4, this.p);
        }
        return d;
    }

    private final double preDistanceVM(NumberVector numberVector, SpatialComparable spatialComparable, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = spatialComparable.getMin(i);
            double d4 = d3 - d2;
            if (d4 < 0.0) {
                d4 = d2 - spatialComparable.getMax(i);
            }
            if (!(d4 > 0.0)) continue;
            d += Math.pow(d4, this.p);
        }
        return d;
    }

    private final double preDistanceMBR(SpatialComparable spatialComparable, SpatialComparable spatialComparable2, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = spatialComparable2.getMin(i) - spatialComparable.getMax(i);
            if (d2 < 0.0) {
                d2 = spatialComparable.getMin(i) - spatialComparable2.getMax(i);
            }
            if (!(d2 > 0.0)) continue;
            d += Math.pow(d2, this.p);
        }
        return d;
    }

    private final double preNorm(NumberVector numberVector, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = d2 >= 0.0 ? d2 : -d2;
            d += Math.pow(d3, this.p);
        }
        return d;
    }

    private final double preNormMBR(SpatialComparable spatialComparable, int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            double d2 = spatialComparable.getMin(i);
            if (d2 < 0.0) {
                d2 = -spatialComparable.getMax(i);
            }
            if (!(d2 > 0.0)) continue;
            d += Math.pow(d2, this.p);
        }
        return d;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        int n3 = n2 < (n = numberVector2.getDimensionality()) ? n2 : n;
        double d = this.preDistance(numberVector, numberVector2, 0, n3, 0.0);
        if (n2 > n3) {
            d = this.preNorm(numberVector, n3, n2, d);
        } else if (n > n3) {
            d = this.preNorm(numberVector2, n3, n, d);
        }
        return Math.pow(d, this.invp);
    }

    @Override
    public double norm(NumberVector numberVector) {
        return Math.pow(this.preNorm(numberVector, 0, numberVector.getDimensionality(), 0.0), this.invp);
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n;
        int n2 = spatialComparable.getDimensionality();
        int n3 = n2 < (n = spatialComparable2.getDimensionality()) ? n2 : n;
        NumberVector numberVector = spatialComparable instanceof NumberVector ? (NumberVector)spatialComparable : null;
        NumberVector numberVector2 = spatialComparable2 instanceof NumberVector ? (NumberVector)spatialComparable2 : null;
        double d = 0.0;
        d = numberVector != null ? (numberVector2 != null ? this.preDistance(numberVector, numberVector2, 0, n3, d) : this.preDistanceVM(numberVector, spatialComparable2, 0, n3, d)) : (numberVector2 != null ? this.preDistanceVM(numberVector2, spatialComparable, 0, n3, d) : this.preDistanceMBR(spatialComparable, spatialComparable2, 0, n3, d));
        if (n2 > n3) {
            d = numberVector != null ? this.preNorm(numberVector, n3, n2, d) : this.preNormMBR(numberVector, n3, n2, d);
        }
        if (n > n3) {
            d = numberVector2 != null ? this.preNorm(numberVector2, n3, n, d) : this.preNormMBR(spatialComparable2, n3, n, d);
        }
        return Math.pow(d, this.invp);
    }

    @Override
    public boolean isMetric() {
        return this.p >= 1.0;
    }

    public String toString() {
        return "L_" + this.p + "Norm";
    }

    public double getP() {
        return this.p;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof LPNormDistanceFunction) {
            return this.p == ((LPNormDistanceFunction)object).p;
        }
        return false;
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID P_ID = new OptionID("lpnorm.p", "the degree of the L-P-Norm (positive number)");
        protected double p;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(P_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.p = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected LPNormDistanceFunction makeInstance() {
            if (this.p == 1.0) {
                return ManhattanDistanceFunction.STATIC;
            }
            if (this.p == 2.0) {
                return EuclideanDistanceFunction.STATIC;
            }
            if (this.p == Double.POSITIVE_INFINITY) {
                return MaximumDistanceFunction.STATIC;
            }
            if (this.p == (double)Math.round(this.p)) {
                return new LPIntegerNormDistanceFunction((int)this.p);
            }
            return new LPNormDistanceFunction(this.p);
        }
    }
}

