/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.SparseManhattanDistanceFunction"})
public class SparseManhattanDistanceFunction
extends SparseLPNormDistanceFunction {
    public static final SparseManhattanDistanceFunction STATIC = new SparseManhattanDistanceFunction();

    @Deprecated
    public SparseManhattanDistanceFunction() {
        super(1.0);
    }

    @Override
    public double distance(SparseNumberVector sparseNumberVector, SparseNumberVector sparseNumberVector2) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        int n2 = sparseNumberVector2.iter();
        while (sparseNumberVector.iterValid(n) && sparseNumberVector2.iterValid(n2)) {
            double d2;
            int n3;
            int n4 = sparseNumberVector.iterDim(n);
            if (n4 < (n3 = sparseNumberVector2.iterDim(n2))) {
                d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
                d += d2;
                n = sparseNumberVector.iterAdvance(n);
                continue;
            }
            if (n3 < n4) {
                d2 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
                d += d2;
                n2 = sparseNumberVector2.iterAdvance(n2);
                continue;
            }
            d2 = Math.abs(sparseNumberVector.iterDoubleValue(n) - sparseNumberVector2.iterDoubleValue(n2));
            d += d2;
            n = sparseNumberVector.iterAdvance(n);
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        while (sparseNumberVector.iterValid(n)) {
            double d3 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            d += d3;
            n = sparseNumberVector.iterAdvance(n);
        }
        while (sparseNumberVector2.iterValid(n2)) {
            double d4 = Math.abs(sparseNumberVector2.iterDoubleValue(n2));
            d += d4;
            n2 = sparseNumberVector2.iterAdvance(n2);
        }
        return d;
    }

    @Override
    public double norm(SparseNumberVector sparseNumberVector) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        while (sparseNumberVector.iterValid(n)) {
            double d2 = Math.abs(sparseNumberVector.iterDoubleValue(n));
            d += d2;
            n = sparseNumberVector.iterAdvance(n);
        }
        return d;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SparseManhattanDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

