/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialNorm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedSquaredEuclideanDistanceFunction"})
public class WeightedSquaredEuclideanDistanceFunction
extends AbstractSpatialNorm
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    protected double[] weights;

    public WeightedSquaredEuclideanDistanceFunction(double[] dArray) {
        this.weights = dArray;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = WeightedSquaredEuclideanDistanceFunction.dimensionality(numberVector, numberVector2, this.weights.length);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i) - numberVector2.doubleValue(i);
            d += d2 * d2 * this.weights[i];
        }
        return d;
    }

    @Override
    public double norm(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(n);
            d += d2 * d2 * this.weights[i];
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable instanceof NumberVector && spatialComparable2 instanceof NumberVector) {
            return this.distance((NumberVector)spatialComparable, (NumberVector)spatialComparable2);
        }
        int n = WeightedSquaredEuclideanDistanceFunction.dimensionality(spatialComparable, spatialComparable2, this.weights.length);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            if (spatialComparable.getMax(i) < spatialComparable2.getMin(i)) {
                d2 = spatialComparable2.getMin(i) - spatialComparable.getMax(i);
            } else {
                if (!(spatialComparable.getMin(i) > spatialComparable2.getMax(i))) continue;
                d2 = spatialComparable.getMin(i) - spatialComparable2.getMax(i);
            }
            d += d2 * d2 * this.weights[i];
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof WeightedSquaredEuclideanDistanceFunction)) {
            if (object.getClass().equals(SquaredEuclideanDistanceFunction.class)) {
                for (double d : this.weights) {
                    if (d == 1.0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        WeightedSquaredEuclideanDistanceFunction weightedSquaredEuclideanDistanceFunction = (WeightedSquaredEuclideanDistanceFunction)object;
        return Arrays.equals(this.weights, weightedSquaredEuclideanDistanceFunction.weights);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (parameterization.grab(doubleListParameter)) {
                this.weights = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected WeightedSquaredEuclideanDistanceFunction makeInstance() {
            return new WeightedSquaredEuclideanDistanceFunction(this.weights);
        }
    }
}

