/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="S. Kullback", title="Information theory and statistics", booktitle="Information theory and statistics, Courier Dover Publications, 1997.")
@Alias(value={"kl"})
public class KullbackLeiblerDivergenceAsymmetricDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final KullbackLeiblerDivergenceAsymmetricDistanceFunction STATIC = new KullbackLeiblerDivergenceAsymmetricDistanceFunction();

    @Deprecated
    public KullbackLeiblerDivergenceAsymmetricDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = KullbackLeiblerDivergenceAsymmetricDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = numberVector2.doubleValue(i);
            if (d3 <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(d2 > 0.0)) continue;
            d += d2 * Math.log(d2 / d3);
        }
        return d;
    }

    @Override
    public boolean isSymmetric() {
        return false;
    }

    public String toString() {
        return "KullbackLeiblerDivergenceDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected KullbackLeiblerDivergenceAsymmetricDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

