/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="Derivative dynamic time warping")
@Reference(authors="E. J. Keogh and M. J. Pazzani", title="Derivative dynamic time warping", booktitle="1st SIAM International Conference on Data Mining (SDM-2001)", url="https://siam.org/proceedings/datamining/2001/dm01_01KeoghE.pdf")
public class DerivativeDTWDistanceFunction
extends DTWDistanceFunction {
    public DerivativeDTWDistanceFunction() {
        this(Double.POSITIVE_INFINITY);
    }

    public DerivativeDTWDistanceFunction(double d) {
        super(d);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        int n2 = numberVector2.getDimensionality();
        int n3 = n2 - 1;
        int n4 = this.effectiveBandSize(n, n2);
        if (Math.abs(n - n2) > n4) {
            return Double.POSITIVE_INFINITY;
        }
        double[] dArray = new double[n2 << 1];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        this.firstRow(dArray, n4, numberVector, numberVector2, n2);
        int n5 = 0;
        int n6 = n2;
        int n7 = 1;
        int n8 = 0;
        int n9 = Math.min(n3, n7 + n4);
        while (n7 < n) {
            double d = this.derivative(n7, numberVector);
            for (int i = n8; i <= n9; ++i) {
                double d2 = dArray[n5 + i];
                if (i > 0) {
                    double d3 = dArray[n5 + i - 1];
                    double d4 = d2 = d3 < d2 ? d3 : d2;
                    if (i > n8) {
                        double d5 = dArray[n6 + i - 1];
                        d2 = d5 < d2 ? d5 : d2;
                    }
                }
                dArray[n6 + i] = d2 + this.delta(d, this.derivative(i, numberVector2));
            }
            n5 = n2 - n5;
            n6 = n2 - n6;
            if (++n7 > n4) {
                ++n8;
            }
            if (n9 >= n3) continue;
            ++n9;
        }
        return Math.sqrt(dArray[n5 + n2 - 1]);
    }

    @Override
    protected void firstRow(double[] dArray, int n, NumberVector numberVector, NumberVector numberVector2, int n2) {
        double d = this.derivative(0, numberVector);
        dArray[0] = this.delta(d, this.derivative(0, numberVector2));
        int n3 = n >= n2 ? n2 - 1 : n;
        for (int i = 1; i <= n3; ++i) {
            dArray[i] = dArray[i - 1] + this.delta(d, this.derivative(i, numberVector2));
        }
    }

    public double derivative(int n, NumberVector numberVector) {
        int n2 = numberVector.getDimensionality();
        if (n2 == 1) {
            return 0.0;
        }
        n = n == 0 ? 1 : (n == n2 - 1 ? n2 - 2 : n);
        return (numberVector.doubleValue(n) - numberVector.doubleValue(n - 1) + (numberVector.doubleValue(n + 1) - numberVector.doubleValue(n - 1)) * 0.5) * 0.5;
    }
}

