/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.query.DistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class PolynomialKernelFunction
extends AbstractVectorSimilarityFunction
implements PrimitiveDistanceFunction<NumberVector> {
    public static final int DEFAULT_DEGREE = 2;
    private final int degree;
    private final double bias;

    public PolynomialKernelFunction(int n, double d) {
        this.degree = n;
        this.bias = d;
    }

    public PolynomialKernelFunction(int n) {
        this(n, 0.0);
    }

    @Override
    public double similarity(NumberVector numberVector, NumberVector numberVector2) {
        int n = AbstractNumberVectorDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += numberVector.doubleValue(i) * numberVector2.doubleValue(i);
        }
        return MathUtil.powi(d + this.bias, this.degree);
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        return Math.sqrt(this.similarity(numberVector, numberVector) + this.similarity(numberVector2, numberVector2) - 2.0 * this.similarity(numberVector, numberVector2));
    }

    @Override
    public <T extends NumberVector> DistanceSimilarityQuery<T> instantiate(Relation<T> relation) {
        return new PrimitiveDistanceSimilarityQuery<NumberVector>(relation, this, this);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DEGREE_ID = new OptionID("kernel.polynomial.degree", "The degree of the polynomial kernel function. Default: 2");
        public static final OptionID BIAS_ID = new OptionID("kernel.polynomial.bias", "The bias of the polynomial kernel, a constant that is added to the scalar product.");
        protected int degree = 0;
        protected double bias = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(DEGREE_ID, 2);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.degree = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(BIAS_ID);
            doubleParameter.setOptional(true);
            if (parameterization.grab(doubleParameter)) {
                this.bias = doubleParameter.doubleValue();
            }
        }

        @Override
        protected PolynomialKernelFunction makeInstance() {
            if (this.degree == 1 && this.bias == 0.0) {
                return LinearKernelFunction.STATIC;
            }
            return new PolynomialKernelFunction(this.degree, this.bias);
        }
    }
}

