/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Pantel, P. and Lin, D.", title="Document clustering with committees", booktitle="Proc. 25th ACM SIGIR conference on Research and development in information retrieval", url="http://dx.doi.org/10.1145/564376.564412")
public class EditDistance {
    int editFirst = -1;
    int editSecond = -1;
    int editOperationsBaseline;

    protected EditDistance(ClusterContingencyTable clusterContingencyTable) {
        int n;
        int n2;
        int n3;
        this.editOperationsBaseline = clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2];
        this.editFirst = 0;
        for (n3 = 0; n3 < clusterContingencyTable.size1; ++n3) {
            n2 = 0;
            for (n = 0; n < clusterContingencyTable.size2; ++n) {
                n2 = Math.max(n2, clusterContingencyTable.contingency[n3][n]);
            }
            ++this.editFirst;
            this.editFirst += clusterContingencyTable.contingency[n3][clusterContingencyTable.size2] - n2;
        }
        this.editSecond = 0;
        for (n3 = 0; n3 < clusterContingencyTable.size2; ++n3) {
            n2 = 0;
            for (n = 0; n < clusterContingencyTable.size1; ++n) {
                n2 = Math.max(n2, clusterContingencyTable.contingency[n][n3]);
            }
            ++this.editSecond;
            this.editSecond += clusterContingencyTable.contingency[clusterContingencyTable.size1][n3] - n2;
        }
    }

    public int editOperationsBaseline() {
        return this.editOperationsBaseline;
    }

    public int editOperationsFirst() {
        return this.editFirst;
    }

    public int editOperationsSecond() {
        return this.editSecond;
    }

    public double editDistanceFirst() {
        return 1.0 - 1.0 * (double)this.editOperationsFirst() / (double)this.editOperationsBaseline();
    }

    public double editDistanceSecond() {
        return 1.0 - 1.0 * (double)this.editOperationsSecond() / (double)this.editOperationsBaseline();
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.editDistanceFirst(), this.editDistanceSecond());
    }
}

