/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.AbstractScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class ROCEvaluation
extends AbstractScoreEvaluation {
    public static final ROCEvaluation STATIC = new ROCEvaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I i) {
        return ROCEvaluation.computeROCAUC(predicate, i);
    }

    public static <I extends ScoreEvaluation.ScoreIter> XYCurve materializeROC(ScoreEvaluation.Predicate<? super I> predicate, I i) {
        int n = 0;
        int n2 = 0;
        XYCurve xYCurve = new XYCurve("False Positive Rate", "True Positive Rate");
        xYCurve.add(0.0, 0.0);
        while (i.valid()) {
            do {
                if (predicate.test(i)) {
                    ++n;
                } else {
                    ++n2;
                }
                i.advance();
            } while (i.valid() && i.tiedToPrevious());
            xYCurve.addAndSimplify(n2, n);
        }
        xYCurve.addAndSimplify(n2, n);
        xYCurve.rescale(1.0 / (double)n2, 1.0 / (double)n);
        return xYCurve;
    }

    @Override
    public double expected(int n, int n2) {
        return 0.5;
    }

    public static <I extends ScoreEvaluation.ScoreIter> double computeROCAUC(ScoreEvaluation.Predicate<? super I> predicate, I i) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        while (i.valid()) {
            do {
                if (predicate.test(i)) {
                    ++n;
                } else {
                    ++n2;
                }
                i.advance();
            } while (i.valid() && i.tiedToPrevious());
            if (n2 > n4) {
                d += (double)(n + n3) * 0.5 * (double)(n2 - n4);
                n4 = n2;
            }
            n3 = n;
        }
        return (d /= (double)((long)n2 * (long)n)) == d ? d : 0.5;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ROCEvaluation makeInstance() {
            return STATIC;
        }
    }
}

