/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.gui.configurator.ConfiguratorPanel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ParameterTabPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(ParameterTabPanel.class);
    private final ConfiguratorPanel parameterTable;
    private final JButton runButton;
    private final JLabel statusText;

    public ParameterTabPanel() {
        this.setLayout(new GridBagLayout());
        JComponent jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        this.runButton = new JButton("Run Task");
        this.runButton.setMnemonic(82);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ParameterTabPanel.this.execute();
                    }
                };
                thread.start();
            }
        });
        jComponent.add(this.runButton);
        this.statusText = new JLabel();
        jComponent.add(this.statusText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        this.add((Component)jComponent, gridBagConstraints);
        this.parameterTable = new ConfiguratorPanel();
        this.parameterTable.addChangeListener(this);
        jComponent = new JScrollPane(this.parameterTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected void updateParameterTable() {
        this.parameterTable.setEnabled(false);
        ListParameterization listParameterization = new ListParameterization();
        this.parameterTable.appendParameters(listParameterization);
        this.setParameters(listParameterization);
        if (listParameterization.getErrors().size() > 0) {
            this.reportErrors(listParameterization);
        }
        listParameterization.clearErrors();
        this.parameterTable.setEnabled(true);
    }

    public void setParameters(Parameterization parameterization) {
        TrackParameters trackParameters = new TrackParameters(parameterization);
        this.configureStep(trackParameters);
        this.parameterTable.setEnabled(false);
        this.parameterTable.clear();
        for (TrackedParameter trackedParameter : trackParameters.getAllParameters()) {
            this.parameterTable.addParameter(trackedParameter.getOwner(), trackedParameter.getParameter(), trackParameters);
        }
        this.parameterTable.revalidate();
        this.parameterTable.setEnabled(true);
        this.updateStatus();
        this.firePanelUpdated();
    }

    public void appendParameters(ListParameterization listParameterization) {
        this.parameterTable.appendParameters(listParameterization);
    }

    protected void reportErrors(Parameterization parameterization) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterException parameterException : parameterization.getErrors()) {
            if (parameterException instanceof UnspecifiedParameterException) continue;
            stringBuilder.append(parameterException.getMessage()).append(FormatUtil.NEWLINE);
        }
        if (stringBuilder.length() > 0) {
            LOG.warning("Configuration errors:" + FormatUtil.NEWLINE + FormatUtil.NEWLINE + stringBuilder.toString());
        }
    }

    protected synchronized void execute() {
        ListParameterization listParameterization = new ListParameterization();
        this.parameterTable.appendParameters(listParameterization);
        this.runButton.setEnabled(false);
        try {
            this.configureStep(listParameterization);
            if (listParameterization.hasUnusedParameters()) {
                LOG.warning("Unused parameters: FIXME");
            }
            if (listParameterization.getErrors().size() > 0) {
                this.reportErrors(listParameterization);
            } else {
                this.executeStep();
            }
        }
        catch (Exception exception) {
            LOG.exception(exception);
        }
        this.updateStatus();
        this.firePanelUpdated();
    }

    protected abstract void configureStep(Parameterization var1);

    protected abstract Status getStatus();

    protected abstract void executeStep();

    public boolean canRun() {
        Status status = this.getStatus();
        return Status.STATUS_READY.equals((Object)status) || Status.STATUS_COMPLETE.equals((Object)status);
    }

    public boolean isComplete() {
        Status status = this.getStatus();
        return Status.STATUS_COMPLETE.equals((Object)status);
    }

    protected void updateStatus() {
        this.statusText.setText(this.getStatus().toString());
        this.runButton.setEnabled(this.canRun());
    }

    protected void firePanelUpdated() {
        for (ParameterTabPanel parameterTabPanel : (ParameterTabPanel[])this.listenerList.getListeners(ParameterTabPanel.class)) {
            parameterTabPanel.panelUpdated(this);
        }
    }

    public void addPanelListener(ParameterTabPanel parameterTabPanel) {
        this.listenerList.add(ParameterTabPanel.class, parameterTabPanel);
    }

    public void removePanelListener(ParameterTabPanel parameterTabPanel) {
        this.listenerList.remove(ParameterTabPanel.class, parameterTabPanel);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.parameterTable) {
            this.updateParameterTable();
        }
    }

    void panelUpdated(ParameterTabPanel parameterTabPanel) {
    }

    public static enum Status {
        STATUS_UNCONFIGURED{

            public String toString() {
                return "unconfigured";
            }
        }
        ,
        STATUS_CONFIGURED{

            public String toString() {
                return "configured";
            }
        }
        ,
        STATUS_READY{

            public String toString() {
                return "ready to run";
            }
        }
        ,
        STATUS_COMPLETE{

            public String toString() {
                return "complete";
            }
        }
        ,
        STATUS_FAILED{

            public String toString() {
                return "failed";
            }
        };

    }
}

