/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.util.LogPane;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected LogPane logpane = new LogPane();
    protected HashMap<Progress, JProgressBar> pbarmap = new HashMap();

    public LogPanel() {
        super.setLayout(new BoxLayout(this, 1));
        JScrollPane jScrollPane = new JScrollPane(this.logpane);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        super.add(jScrollPane);
    }

    public void becomeDefaultLogger() {
        LoggingConfiguration.replaceDefaultHandler(new LogPanelHandler());
    }

    public void publish(String string, Level level) {
        try {
            this.publish(new LogRecord(level, string));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing a log-like message.", exception);
        }
    }

    public void publish(LogRecord logRecord) {
        if (logRecord instanceof ProgressLogRecord) {
            ProgressLogRecord progressLogRecord = (ProgressLogRecord)logRecord;
            Progress progress = progressLogRecord.getProgress();
            JProgressBar jProgressBar = this.getOrCreateProgressBar(progress);
            this.updateProgressBar(progress, jProgressBar);
            if (progress.isComplete()) {
                this.removeProgressBar(progress, jProgressBar);
            }
            if (progress.isComplete() || progress instanceof StepProgress) {
                this.publishTextRecord(logRecord);
            }
        } else {
            this.publishTextRecord(logRecord);
        }
    }

    private void publishTextRecord(LogRecord logRecord) {
        try {
            this.logpane.publish(logRecord);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing a log-like message.", exception);
        }
    }

    private JProgressBar getOrCreateProgressBar(Progress progress) {
        JProgressBar jProgressBar = this.pbarmap.get(progress);
        if (jProgressBar == null) {
            if (progress instanceof FiniteProgress) {
                jProgressBar = new JProgressBar(0, ((FiniteProgress)progress).getTotal());
                jProgressBar.setStringPainted(true);
            } else if (progress instanceof IndefiniteProgress) {
                jProgressBar = new JProgressBar();
                jProgressBar.setIndeterminate(true);
                jProgressBar.setStringPainted(true);
            } else if (progress instanceof MutableProgress) {
                jProgressBar = new JProgressBar(0, ((MutableProgress)progress).getTotal());
                jProgressBar.setStringPainted(true);
            } else {
                throw new RuntimeException("Unsupported progress record");
            }
            this.pbarmap.put(progress, jProgressBar);
            final JProgressBar jProgressBar2 = jProgressBar;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogPanel.this.addProgressBar(jProgressBar2);
                }
            });
        }
        return jProgressBar;
    }

    private void updateProgressBar(Progress progress, JProgressBar jProgressBar) {
        if (progress instanceof FiniteProgress) {
            jProgressBar.setValue(((FiniteProgress)progress).getProcessed());
            jProgressBar.setString(((FiniteProgress)progress).toString());
        } else if (progress instanceof IndefiniteProgress) {
            jProgressBar.setValue(((IndefiniteProgress)progress).getProcessed());
            jProgressBar.setString(((IndefiniteProgress)progress).toString());
        } else if (progress instanceof MutableProgress) {
            jProgressBar.setValue(((MutableProgress)progress).getProcessed());
            jProgressBar.setMaximum(((MutableProgress)progress).getProcessed());
            jProgressBar.setString(((MutableProgress)progress).toString());
        } else {
            throw new RuntimeException("Unsupported progress record");
        }
    }

    private void removeProgressBar(Progress progress, JProgressBar jProgressBar) {
        this.pbarmap.remove(progress);
        final JProgressBar jProgressBar2 = jProgressBar;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPanel.this.removeProgressBar(jProgressBar2);
            }
        });
    }

    public void clear() {
        this.logpane.clear();
        for (Map.Entry<Progress, JProgressBar> entry : this.pbarmap.entrySet()) {
            super.remove(entry.getValue());
            this.pbarmap.remove(entry.getKey());
        }
    }

    protected void addProgressBar(JProgressBar jProgressBar) {
        super.add(jProgressBar);
        super.revalidate();
    }

    protected void removeProgressBar(JProgressBar jProgressBar) {
        super.remove(jProgressBar);
        super.revalidate();
    }

    private class LogPanelHandler
    extends Handler {
        protected LogPanelHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            LogPanel.this.publish(logRecord);
        }
    }
}

