/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.distancematrix;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.DistanceIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

public class PrecomputedDistanceMatrix<O>
extends AbstractIndex<O>
implements DistanceIndex<O>,
RangeIndex<O>,
KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(PrecomputedDistanceMatrix.class);
    protected final DistanceFunction<? super O> distanceFunction;
    protected DistanceQuery<O> distanceQuery;
    private double[] matrix = null;
    private DBIDRange ids;
    private int size;

    public PrecomputedDistanceMatrix(Relation<O> relation, DistanceFunction<? super O> distanceFunction) {
        super(relation);
        this.distanceFunction = distanceFunction;
        if (!distanceFunction.isSymmetric()) {
            throw new AbortException("Distance matrixes currently only support symmetric distance functions (Patches welcome).");
        }
    }

    @Override
    public void initialize() {
        DBIDs dBIDs = this.relation.getDBIDs();
        if (!(dBIDs instanceof DBIDRange)) {
            throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        this.ids = (DBIDRange)dBIDs;
        this.size = this.ids.size();
        if (this.size > 65536) {
            throw new AbortException("Distance matrixes currently have a limit of 65536 objects (~16 GB). After this, the array size exceeds the Java integer range, and a different data structure needs to be used.");
        }
        this.distanceQuery = this.distanceFunction.instantiate(this.relation);
        int n = PrecomputedDistanceMatrix.triangleSize(this.size);
        this.matrix = new double[n];
        DBIDArrayIter dBIDArrayIter = this.ids.iter();
        DBIDArrayIter dBIDArrayIter2 = this.ids.iter();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Precomputing distance matrix", n, LOG) : null;
        int n2 = 0;
        dBIDArrayIter.seek(0);
        while (dBIDArrayIter.valid()) {
            dBIDArrayIter2.seek(0);
            while (dBIDArrayIter2.getOffset() < dBIDArrayIter.getOffset()) {
                this.matrix[n2] = this.distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                ++n2;
                dBIDArrayIter2.advance();
            }
            if (finiteProgress != null) {
                finiteProgress.setProcessed(finiteProgress.getProcessed() + dBIDArrayIter.getOffset(), LOG);
            }
            dBIDArrayIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected static int triangleSize(int n) {
        return n * (n - 1) >>> 1;
    }

    private int getOffset(int n, int n2) {
        return n2 < n ? PrecomputedDistanceMatrix.triangleSize(n) + n2 : PrecomputedDistanceMatrix.triangleSize(n2) + n;
    }

    @Override
    public void logStatistics() {
        if (this.matrix != null) {
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".matrix-size", this.matrix.length));
        }
    }

    @Override
    public String getLongName() {
        return "Precomputed Distance Matrix";
    }

    @Override
    public String getShortName() {
        return "distance-matrix";
    }

    @Override
    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        if (this.distanceQuery.getDistanceFunction().equals(distanceFunction)) {
            return new PrecomputedDistanceQuery();
        }
        return null;
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (this.distanceQuery.getDistanceFunction().equals(distanceQuery.getDistanceFunction())) {
            return new PrecomputedKNNQuery();
        }
        return null;
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (this.distanceQuery.getDistanceFunction().equals(distanceQuery.getDistanceFunction())) {
            return new PrecomputedRangeQuery();
        }
        return null;
    }

    public static class Factory<O>
    implements IndexFactory<O, PrecomputedDistanceMatrix<O>> {
        protected final DistanceFunction<? super O> distanceFunction;

        public Factory(DistanceFunction<? super O> distanceFunction) {
            this.distanceFunction = distanceFunction;
        }

        @Override
        public PrecomputedDistanceMatrix<O> instantiate(Relation<O> relation) {
            return new PrecomputedDistanceMatrix<O>(relation, this.distanceFunction);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("matrix.distance", "Distance function for the precomputed distance matrix.");
            protected DistanceFunction<? super O> distanceFunction;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
                if (parameterization.grab(objectParameter)) {
                    this.distanceFunction = (DistanceFunction)objectParameter.instantiateClass(parameterization);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.distanceFunction);
            }
        }
    }

    private class PrecomputedKNNQuery
    implements KNNQuery<O> {
        private PrecomputedKNNQuery() {
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
            double d;
            int n2;
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            kNNHeap.insert(0.0, dBIDRef);
            DBIDArrayIter dBIDArrayIter = PrecomputedDistanceMatrix.this.ids.iter();
            double d2 = Double.POSITIVE_INFINITY;
            int n3 = PrecomputedDistanceMatrix.this.ids.getOffset(dBIDRef);
            int n4 = PrecomputedDistanceMatrix.triangleSize(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                d = PrecomputedDistanceMatrix.this.matrix[n4];
                if (d <= d2) {
                    d2 = kNNHeap.insert(d, dBIDArrayIter.seek(n2));
                }
                ++n4;
            }
            assert (n4 == PrecomputedDistanceMatrix.triangleSize(n3 + 1));
            n4 = PrecomputedDistanceMatrix.triangleSize(n3 + 1) + n3;
            for (n2 = n3 + 1; n2 < PrecomputedDistanceMatrix.this.size; ++n2) {
                d = PrecomputedDistanceMatrix.this.matrix[n4];
                if (d <= d2) {
                    d2 = kNNHeap.insert(d, dBIDArrayIter.seek(n2));
                }
                n4 += n2;
            }
            return kNNHeap.toKNNList();
        }

        @Override
        public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
            ArrayList<KNNList> arrayList = new ArrayList<KNNList>(arrayDBIDs.size());
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                arrayList.add(this.getKNNForDBID(dBIDArrayIter, n));
                dBIDArrayIter.advance();
            }
            return arrayList;
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }
    }

    private class PrecomputedRangeQuery
    implements RangeQuery<O> {
        private PrecomputedRangeQuery() {
        }

        @Override
        public DoubleDBIDList getRangeForDBID(DBIDRef dBIDRef, double d) {
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
            this.getRangeForDBID(dBIDRef, d, modifiableDoubleDBIDList);
            modifiableDoubleDBIDList.sort();
            return modifiableDoubleDBIDList;
        }

        @Override
        public void getRangeForDBID(DBIDRef dBIDRef, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            double d2;
            int n;
            modifiableDoubleDBIDList.add(0.0, dBIDRef);
            DBIDArrayIter dBIDArrayIter = PrecomputedDistanceMatrix.this.ids.iter();
            int n2 = PrecomputedDistanceMatrix.this.ids.getOffset(dBIDRef);
            int n3 = PrecomputedDistanceMatrix.triangleSize(n2);
            for (n = 0; n < n2; ++n) {
                d2 = PrecomputedDistanceMatrix.this.matrix[n3];
                if (d2 <= d) {
                    modifiableDoubleDBIDList.add(d2, dBIDArrayIter.seek(n));
                }
                ++n3;
            }
            assert (n3 == PrecomputedDistanceMatrix.triangleSize(n2 + 1));
            n3 = PrecomputedDistanceMatrix.triangleSize(n2 + 1) + n2;
            for (n = n2 + 1; n < PrecomputedDistanceMatrix.this.size; ++n) {
                d2 = PrecomputedDistanceMatrix.this.matrix[n3];
                if (d2 <= d) {
                    modifiableDoubleDBIDList.add(d2, dBIDArrayIter.seek(n));
                }
                n3 += n;
            }
        }

        @Override
        public DoubleDBIDList getRangeForObject(O o, double d) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }
    }

    private class PrecomputedDistanceQuery
    implements DistanceQuery<O> {
        private PrecomputedDistanceQuery() {
        }

        @Override
        public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            int n;
            int n2 = PrecomputedDistanceMatrix.this.ids.getOffset(dBIDRef);
            return n2 != (n = PrecomputedDistanceMatrix.this.ids.getOffset(dBIDRef2)) ? PrecomputedDistanceMatrix.this.matrix[PrecomputedDistanceMatrix.this.getOffset(n2, n)] : 0.0;
        }

        @Override
        public double distance(O o, DBIDRef dBIDRef) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance((DBIDRef)o, dBIDRef);
        }

        @Override
        public double distance(DBIDRef dBIDRef, O o) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance(dBIDRef, (DBIDRef)o);
        }

        @Override
        public double distance(O o, O o2) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance(o, o2);
        }

        @Override
        public DistanceFunction<? super O> getDistanceFunction() {
            return PrecomputedDistanceMatrix.this.distanceQuery.getDistanceFunction();
        }

        @Override
        public Relation<? extends O> getRelation() {
            return PrecomputedDistanceMatrix.this.relation;
        }
    }
}

