/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.fastoptics;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

@Reference(authors="J. Schneider and M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM international conference on Conference on Information & Knowledge Management (CIKM)", url="http://dx.doi.org/10.1145/2505515.2505590")
public class RandomProjectedNeighborsAndDensities<V extends NumberVector> {
    private static final Logging LOG = Logging.getLogger(RandomProjectedNeighborsAndDensities.class);
    private static final String PREFIX = RandomProjectedNeighborsAndDensities.class.getName();
    private static final int logOProjectionConst = 20;
    private static final float sizeTolerance = 0.6666667f;
    int minSplitSize;
    Relation<V> points;
    ArrayList<ArrayDBIDs> splitsets;
    DoubleDataStore[] projectedPoints;
    RandomFactory rnd;
    long distanceComputations;

    public RandomProjectedNeighborsAndDensities(RandomFactory randomFactory) {
        this.rnd = randomFactory;
    }

    public void computeSetsBounds(Relation<V> relation, int n, DBIDs dBIDs) {
        Object object;
        this.minSplitSize = n;
        int n2 = relation.size();
        int n3 = RelationUtil.dimensionality(relation);
        this.points = relation;
        int n4 = (int)(20.0 * MathUtil.log2(n2 * n3 + 1));
        int n5 = (int)(20.0 * MathUtil.log2(n2 * n3 + 1));
        LOG.statistics(new LongStatistic(PREFIX + ".partition-size", n4));
        LOG.statistics(new LongStatistic(PREFIX + ".num-projections", n5));
        this.splitsets = new ArrayList();
        this.projectedPoints = new DoubleDataStore[n5];
        DoubleDataStore[] doubleDataStoreArray = new DoubleDataStore[n5];
        Random random = this.rnd.getSingleThreadedRandom();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Random projections", n5, LOG) : null;
        for (int i = 0; i < n5; ++i) {
            int n6;
            double[] dArray = new double[n3];
            double d = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                double d2;
                dArray[n6] = d2 = random.nextDouble() - 0.5;
                d += d2 * d2;
            }
            d = Math.sqrt(d);
            n6 = 0;
            while (n6 < n3) {
                int n7 = n6++;
                dArray[n7] = dArray[n7] / d;
            }
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 2);
            object = dBIDs.iter();
            while (object.valid()) {
                NumberVector numberVector = (NumberVector)relation.get((DBIDRef)object);
                double d3 = 0.0;
                for (int j = 0; j < n3; ++j) {
                    d3 += dArray[j] * numberVector.doubleValue(j);
                }
                writableDoubleDataStore.put((DBIDRef)object, d3);
                object.advance();
            }
            this.projectedPoints[i] = writableDoubleDataStore;
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        long l = n5 * dBIDs.size();
        LOG.statistics(new LongStatistic(PREFIX + ".num-scalar-products", l));
        TIntArrayList tIntArrayList = new TIntArrayList(n5);
        for (int i = 0; i < n5; ++i) {
            tIntArrayList.add(i);
        }
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Splitting data", n4, LOG) : null;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                doubleDataStoreArray[j] = this.projectedPoints[j];
            }
            tIntArrayList.shuffle(random);
            object = tIntArrayList.iterator();
            int n8 = 0;
            while (object.hasNext()) {
                int n9 = object.next();
                this.projectedPoints[n9] = doubleDataStoreArray[n8];
                ++n8;
            }
            this.splitupNoSort(DBIDUtil.newArray(dBIDs), 0, n2, 0, random);
            LOG.incrementProcessed(finiteProgress2);
        }
        LOG.ensureCompleted(finiteProgress2);
    }

    public void splitupNoSort(ArrayModifiableDBIDs arrayModifiableDBIDs, int n, int n2, int n3, Random random) {
        int n4 = n2 - n;
        DoubleDataStore doubleDataStore = this.projectedPoints[n3 %= this.projectedPoints.length];
        if ((float)n4 > (float)this.minSplitSize * 0.3333333f && (float)n4 < (float)this.minSplitSize * 1.6666667f) {
            arrayModifiableDBIDs.sort(n, n2, new DataStoreUtil.AscendingByDoubleDataStore(doubleDataStore));
            this.splitsets.add(DBIDUtil.newArray(arrayModifiableDBIDs.slice(n, n2)));
        }
        if (n4 > this.minSplitSize) {
            int n5 = this.splitRandomly(arrayModifiableDBIDs, n, n2, doubleDataStore, random);
            int n6 = n5 + 1;
            this.splitupNoSort(arrayModifiableDBIDs, n, n6, n3 + 1, random);
            this.splitupNoSort(arrayModifiableDBIDs, n6, n2, n3 + 1, random);
        }
    }

    public int splitRandomly(ArrayModifiableDBIDs arrayModifiableDBIDs, int n, int n2, DoubleDataStore doubleDataStore, Random random) {
        int n3;
        int n4 = n2 - n;
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        double d = doubleDataStore.doubleValue(dBIDArrayMIter.seek(n + random.nextInt(n4)));
        int n5 = n2 - 1;
        for (n3 = n; n3 < n5; ++n3) {
            double d2 = doubleDataStore.doubleValue(dBIDArrayMIter.seek(n3));
            if (!(d2 > d)) continue;
            while (n3 < n5 && doubleDataStore.doubleValue(dBIDArrayMIter.seek(n5)) > d) {
                --n5;
            }
            if (n3 == n5) break;
            arrayModifiableDBIDs.swap(n3, n5);
            --n5;
        }
        if (n3 == n2 - 1) {
            n3 = n + n2 >>> 1;
        }
        return n3;
    }

    public int splitByDistance(ArrayModifiableDBIDs arrayModifiableDBIDs, int n, int n2, DoubleDataStore doubleDataStore, Random random) {
        double d;
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        double d2 = 8.988465674311579E307;
        double d3 = -8.988465674311579E307;
        int n3 = n;
        int n4 = n2 - 1;
        dBIDArrayMIter.seek(n);
        while (dBIDArrayMIter.getOffset() < n2) {
            d = doubleDataStore.doubleValue(dBIDArrayMIter);
            d2 = Math.min(d, d2);
            d3 = Math.max(d, d3);
            dBIDArrayMIter.advance();
        }
        if (d2 != d3) {
            d = d2 + random.nextDouble() * (d3 - d2);
            while (n3 < n4) {
                double d4 = doubleDataStore.doubleValue(dBIDArrayMIter.seek(n3));
                if (d4 > d) {
                    while (n3 < n4 && doubleDataStore.doubleValue(dBIDArrayMIter.seek(n4)) > d) {
                        --n4;
                    }
                    if (n3 == n4) break;
                    arrayModifiableDBIDs.swap(n3, n4);
                    --n4;
                }
                ++n3;
            }
        } else {
            n3 = n + n2 >>> 1;
        }
        return n3;
    }

    public DataStore<? extends DBIDs> getNeighs() {
        DBIDs dBIDs = this.points.getDBIDs();
        WritableDataStore<ModifiableDBIDs> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 2, ModifiableDBIDs.class);
        Object object = dBIDs.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, DBIDUtil.newHashSet());
            object.advance();
        }
        object = LOG.isVerbose() ? new FiniteProgress("Processing splits for neighborhoods", this.splitsets.size(), LOG) : null;
        Iterator<ArrayDBIDs> iterator = this.splitsets.iterator();
        DBIDVar dBIDVar = DBIDUtil.newVar();
        while (iterator.hasNext()) {
            ArrayDBIDs arrayDBIDs = iterator.next();
            int n = arrayDBIDs.size() >> 1;
            arrayDBIDs.assignVar(n, dBIDVar);
            ((ModifiableDBIDs)writableDataStore.get(dBIDVar)).addDBIDs(arrayDBIDs);
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                ((ModifiableDBIDs)writableDataStore.get(dBIDArrayIter)).add(dBIDVar);
                dBIDArrayIter.advance();
            }
            LOG.incrementProcessed((AbstractProgress)object);
        }
        LOG.ensureCompleted((FiniteProgress)object);
        return writableDataStore;
    }

    public DoubleDataStore computeAverageDistInSet() {
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(this.points.getDBIDs(), 2);
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(this.points.getDBIDs(), 3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing splits for density estimation", this.splitsets.size(), LOG) : null;
        DBIDVar dBIDVar = DBIDUtil.newVar();
        for (ArrayDBIDs arrayDBIDs : this.splitsets) {
            int n = arrayDBIDs.size();
            int n2 = n >> 1;
            arrayDBIDs.assignVar(n2, dBIDVar);
            NumberVector numberVector = (NumberVector)this.points.get(dBIDVar);
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.getOffset() < n) {
                if (!DBIDUtil.equal(dBIDArrayIter, dBIDVar)) {
                    double d = EuclideanDistanceFunction.STATIC.distance((NumberVector)this.points.get(dBIDArrayIter), numberVector);
                    ++this.distanceComputations;
                    writableDoubleDataStore.increment(dBIDVar, d);
                    writableIntegerDataStore.increment(dBIDVar, 1);
                    writableDoubleDataStore.increment(dBIDArrayIter, d);
                    writableIntegerDataStore.increment(dBIDArrayIter, 1);
                }
                dBIDArrayIter.advance();
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        DBIDIter dBIDIter = this.points.getDBIDs().iter();
        while (dBIDIter.valid()) {
            int n = writableIntegerDataStore.intValue(dBIDIter);
            double d = n == 0 ? (double)-0.1f : writableDoubleDataStore.doubleValue(dBIDIter) / (double)n;
            writableDoubleDataStore.put((DBIDRef)dBIDIter, d);
            dBIDIter.advance();
        }
        writableIntegerDataStore.destroy();
        return writableDoubleDataStore;
    }

    public void logStatistics() {
        LOG.statistics(new LongStatistic(PREFIX + ".distance-computations", this.distanceComputations));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("fastoptics.randomproj.seed", "Random seed for generating projections.");
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(RANDOM_ID);
            if (parameterization.grab(randomParameter)) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomProjectedNeighborsAndDensities<NumberVector> makeInstance() {
            return new RandomProjectedNeighborsAndDensities<NumberVector>(this.rnd);
        }
    }
}

