/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import java.util.logging.Logger;

public abstract class AbstractMTreeNode<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
extends AbstractNode<E> {
    public AbstractMTreeNode() {
    }

    public AbstractMTreeNode(int n, boolean bl, Class<? super E> clazz) {
        super(n, bl, clazz);
    }

    public boolean adjustEntry(E e, DBID dBID, double d, AbstractMTree<O, N, E, ?> abstractMTree) {
        boolean bl = e.setRoutingObjectID(dBID);
        bl |= e.setParentDistance(d);
        return bl |= e.setCoveringRadius(this.coveringRadiusFromEntries(dBID, abstractMTree));
    }

    public double coveringRadiusFromEntries(DBID dBID, AbstractMTree<O, N, E, ?> abstractMTree) {
        double d = 0.0;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MTreeEntry mTreeEntry = (MTreeEntry)this.getEntry(i);
            double d2 = mTreeEntry.getParentDistance() + mTreeEntry.getCoveringRadius();
            d = d < d2 ? d2 : d;
        }
        return d;
    }

    public final void integrityCheck(AbstractMTree<O, N, E, ?> abstractMTree, E e) {
        if (this.isLeaf()) {
            for (int i = 0; i < this.getCapacity(); ++i) {
                MTreeEntry mTreeEntry = (MTreeEntry)this.getEntry(i);
                if (i < this.getNumEntries() && mTreeEntry == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i < this.getNumEntries() || mTreeEntry == null) continue;
                throw new RuntimeException("i >= numEntries && entry != null");
            }
        } else {
            AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)abstractMTree.getNode((MTreeEntry)this.getEntry(0));
            boolean bl = abstractMTreeNode.isLeaf();
            for (int i = 0; i < this.getCapacity(); ++i) {
                MTreeEntry mTreeEntry = (MTreeEntry)this.getEntry(i);
                if (i < this.getNumEntries() && mTreeEntry == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i >= this.getNumEntries() && mTreeEntry != null) {
                    throw new RuntimeException("i >= numEntries && entry != null");
                }
                if (mTreeEntry == null) continue;
                AbstractMTreeNode abstractMTreeNode2 = (AbstractMTreeNode)abstractMTree.getNode(mTreeEntry);
                if (bl && !abstractMTreeNode2.isLeaf()) {
                    for (int j = 0; j < this.getNumEntries(); ++j) {
                        abstractMTree.getNode((MTreeEntry)this.getEntry(j));
                    }
                    throw new RuntimeException("Wrong Child in " + this + " at " + i);
                }
                if (!bl && abstractMTreeNode2.isLeaf()) {
                    throw new RuntimeException("Wrong Child: child id no leaf, but node is leaf!");
                }
                abstractMTreeNode2.integrityCheckParameters(e, this, i, abstractMTree);
                abstractMTreeNode2.integrityCheck(abstractMTree, mTreeEntry);
            }
            if (LoggingConfiguration.DEBUG) {
                Logger.getLogger(this.getClass().getName()).fine("DirNode " + this.getPageID() + " ok!");
            }
        }
    }

    protected void integrityCheckParameters(E e, N n, int n2, AbstractMTree<O, N, E, ?> abstractMTree) {
        MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)n).getEntry(n2);
        double d = abstractMTree.distance(mTreeEntry.getRoutingObjectID(), e.getRoutingObjectID());
        if (Math.abs(mTreeEntry.getParentDistance() - d) > 1.0E-10) {
            throw new RuntimeException("Wrong parent distance in node " + ((AbstractExternalizablePage)n).getPageID() + " at index " + n2 + " (child " + mTreeEntry + ")" + "\nsoll: " + d + ",\n ist: " + mTreeEntry.getParentDistance());
        }
        double d2 = d + mTreeEntry.getCoveringRadius();
        if (e.getCoveringRadius() < d2 && Math.abs(d - mTreeEntry.getCoveringRadius()) > 1.0E-10) {
            String string = "pcr < pd + cr \n" + e.getCoveringRadius() + " < " + d + " + " + mTreeEntry.getCoveringRadius() + "in node " + ((AbstractExternalizablePage)n).getPageID() + " at index " + n2 + " (child " + mTreeEntry + "):\n" + "dist(" + mTreeEntry.getRoutingObjectID() + " - " + e.getRoutingObjectID() + ")" + " >  cr(" + mTreeEntry + ")";
            throw new RuntimeException(string);
        }
    }
}

