/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeHeader;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.List;
import java.util.Map;

public abstract class AbstractMkTreeUnified<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MkTreeSettings<O, N, E>>
extends AbstractMkTree<O, N, E, S> {
    public AbstractMkTreeUnified(Relation<O> relation, PageFile<N> pageFile, S s) {
        super(relation, pageFile, s);
    }

    @Override
    protected TreeIndexHeader createHeader() {
        return new MkTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, ((MkTreeSettings)this.settings).k_max);
    }

    @Override
    public void insertAll(List<E> list) {
        if (list.size() <= 0) {
            return;
        }
        if (!this.initialized) {
            this.initialize((Entry)list.get(0));
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(list.size());
        for (MTreeEntry mTreeEntry : list) {
            arrayModifiableDBIDs.add(mTreeEntry.getRoutingObjectID());
            super.insert(mTreeEntry, false);
        }
        Map<DBID, KNNList> map = this.batchNN((AbstractMTreeNode)this.getRoot(), arrayModifiableDBIDs, ((MkTreeSettings)this.settings).k_max);
        this.kNNdistanceAdjustment((MTreeEntry)this.getRootEntry(), map);
    }

    protected abstract void kNNdistanceAdjustment(E var1, Map<DBID, KNNList> var2);

    public int getKmax() {
        return ((MkTreeSettings)this.settings).k_max;
    }
}

