/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

public class ConvexHull {
    private int[] lowerHull;
    private int[] upperHull;
    private int l;
    private int u;

    public ConvexHull(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("x and y have different lengths!");
        }
        this.lowerHull = new int[dArray.length];
        this.upperHull = new int[dArray.length];
        this.determineLowerAndUpperHull(dArray, dArray2);
    }

    public int[] getLowerHull() {
        return this.lowerHull;
    }

    public int[] getUpperHull() {
        return this.upperHull;
    }

    public int getNumberOfPointsInLowerHull() {
        return this.l;
    }

    public int getNumberOfPointsInUpperHull() {
        return this.u;
    }

    private void determineLowerAndUpperHull(double[] dArray, double[] dArray2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        this.lowerHull[0] = 0;
        this.l = 1;
        this.upperHull[0] = 0;
        this.u = 1;
        for (n = 1; n < dArray.length; ++n) {
            this.lowerHull[this.l] = n;
            while (this.l >= 2 && (dArray2[this.lowerHull[this.l]] - dArray2[this.lowerHull[this.l - 1]]) / (dArray[this.lowerHull[this.l]] - dArray[this.lowerHull[this.l - 1]]) <= (dArray2[this.lowerHull[this.l - 1]] - dArray2[this.lowerHull[this.l - 2]]) / (dArray[this.lowerHull[this.l - 1]] - dArray[this.lowerHull[this.l - 2]])) {
                this.lowerHull[this.l - 1] = this.lowerHull[this.l];
                --this.l;
            }
            ++this.l;
            this.upperHull[this.u] = n;
            while (this.u >= 2 && (dArray2[this.upperHull[this.u]] - dArray2[this.upperHull[this.u - 1]]) / (dArray[this.upperHull[this.u]] - dArray[this.upperHull[this.u - 1]]) >= (dArray2[this.upperHull[this.u - 1]] - dArray2[this.upperHull[this.u - 2]]) / (dArray[this.upperHull[this.u - 1]] - dArray[this.upperHull[this.u - 2]])) {
                this.upperHull[this.u - 1] = this.upperHull[this.u];
                --this.u;
            }
            ++this.u;
        }
        stringBuilder.append("lower and upper hull\n");
        for (n = 0; n < n; ++n) {
            stringBuilder.append("  uhull ").append(n).append("=").append(this.upperHull[n]).append(" y=").append(dArray2[this.upperHull[n]]).append("\n");
            stringBuilder.append("  lhull ").append(n).append("=").append(this.lowerHull[n]).append(" y=").append(dArray2[this.lowerHull[n]]).append("\n");
        }
    }
}

