/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;

class MkTabTreeNode<O>
extends AbstractMTreeNode<O, MkTabTreeNode<O>, MkTabEntry> {
    private static final long serialVersionUID = 2L;

    public MkTabTreeNode() {
    }

    public MkTabTreeNode(int n, boolean bl) {
        super(n, bl, MkTabEntry.class);
    }

    protected double[] kNNDistances() {
        int n = ((MkTabEntry)this.getEntry(0)).getKnnDistances().length;
        double[] dArray = new double[n];
        for (int i = 0; i < this.getNumEntries(); ++i) {
            for (int j = 0; j < n; ++j) {
                MkTabEntry mkTabEntry = (MkTabEntry)this.getEntry(i);
                dArray[j] = Math.max(dArray[j], mkTabEntry.getKnnDistance(j + 1));
            }
        }
        return dArray;
    }

    @Override
    public boolean adjustEntry(MkTabEntry mkTabEntry, DBID dBID, double d, AbstractMTree<O, MkTabTreeNode<O>, MkTabEntry, ?> abstractMTree) {
        super.adjustEntry(mkTabEntry, dBID, d, abstractMTree);
        mkTabEntry.setKnnDistances(this.kNNDistances());
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkTabEntry mkTabEntry, MkTabTreeNode<O> mkTabTreeNode, int n, AbstractMTree<O, MkTabTreeNode<O>, MkTabEntry, ?> abstractMTree) {
        super.integrityCheckParameters(mkTabEntry, mkTabTreeNode, n, abstractMTree);
        MkTabEntry mkTabEntry2 = (MkTabEntry)mkTabTreeNode.getEntry(n);
        double[] dArray = this.kNNDistances();
        if (!mkTabEntry2.getKnnDistances().equals(dArray)) {
            String string = dArray.toString();
            String string2 = mkTabEntry2.getKnnDistances().toString();
            throw new RuntimeException("Wrong knnDistances in node " + mkTabTreeNode.getPageID() + " at index " + n + " (child " + mkTabEntry2 + ")" + "\nsoll: " + string + ",\n ist: " + string2);
        }
    }
}

