/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu;

import de.lmu.ifi.dbs.elki.index.tree.BreadthFirstEnumeration;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class DeLiCluTree
extends NonFlatRStarTree<DeLiCluNode, DeLiCluEntry, AbstractRTreeSettings> {
    private static final Logging LOG = Logging.getLogger(DeLiCluTree.class);
    private TIntObjectHashMap<TIntHashSet> expanded = new TIntObjectHashMap();

    public DeLiCluTree(PageFile<DeLiCluNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
    }

    public void setExpanded(SpatialEntry spatialEntry, SpatialEntry spatialEntry2) {
        TIntHashSet tIntHashSet = this.expanded.get(this.getPageID(spatialEntry));
        if (tIntHashSet == null) {
            tIntHashSet = new TIntHashSet();
            this.expanded.put(this.getPageID(spatialEntry), tIntHashSet);
        }
        tIntHashSet.add(this.getPageID(spatialEntry2));
    }

    public TIntSet getExpanded(SpatialEntry spatialEntry) {
        TIntHashSet tIntHashSet = this.expanded.get(this.getPageID(spatialEntry));
        if (tIntHashSet != null) {
            return tIntHashSet;
        }
        return new TIntHashSet();
    }

    public TIntSet getExpanded(DeLiCluNode deLiCluNode) {
        TIntHashSet tIntHashSet = this.expanded.get(deLiCluNode.getPageID());
        if (tIntHashSet != null) {
            return tIntHashSet;
        }
        return new TIntHashSet();
    }

    public int numNodes() {
        int n = 0;
        BreadthFirstEnumeration<DeLiCluNode, DeLiCluEntry> breadthFirstEnumeration = new BreadthFirstEnumeration<DeLiCluNode, DeLiCluEntry>(this, this.getRootPath());
        while (breadthFirstEnumeration.hasMoreElements()) {
            Object e = ((IndexTreePath)breadthFirstEnumeration.nextElement()).getEntry();
            if (e.isLeafEntry()) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected DeLiCluNode createNewLeafNode() {
        return new DeLiCluNode(this.leafCapacity, true);
    }

    @Override
    protected DeLiCluNode createNewDirectoryNode() {
        return new DeLiCluNode(this.dirCapacity, false);
    }

    @Override
    protected DeLiCluEntry createNewDirectoryEntry(DeLiCluNode deLiCluNode) {
        return new DeLiCluDirectoryEntry(deLiCluNode.getPageID(), deLiCluNode.computeMBR(), deLiCluNode.hasHandled(), deLiCluNode.hasUnhandled());
    }

    @Override
    protected DeLiCluEntry createRootEntry() {
        return new DeLiCluDirectoryEntry(0, null, false, true);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

