/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert;

import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.reinsert.ReinsertStrategy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractPartialReinsert
implements ReinsertStrategy {
    protected double reinsertAmount = 0.3;
    SpatialPrimitiveDistanceFunction<?> distanceFunction;

    public AbstractPartialReinsert(double d, SpatialPrimitiveDistanceFunction<?> spatialPrimitiveDistanceFunction) {
        this.reinsertAmount = d;
        this.distanceFunction = spatialPrimitiveDistanceFunction;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static OptionID REINSERT_AMOUNT_ID = new OptionID("rtree.reinsertion-amount", "The amount of entries to reinsert.");
        public static OptionID REINSERT_DISTANCE_ID = new OptionID("rtree.reinsertion-distancce", "The distance function to compute reinsertion candidates by.");
        double reinsertAmount = 0.3;
        SpatialPrimitiveDistanceFunction<?> distanceFunction;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(REINSERT_AMOUNT_ID, 0.3);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.reinsertAmount = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(REINSERT_DISTANCE_ID, (Class<?>)SpatialPrimitiveDistanceFunction.class, SquaredEuclideanDistanceFunction.class))) {
                this.distanceFunction = (SpatialPrimitiveDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
        }
    }
}

