/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Matthias Schubert, Ziyue Zhu", title="Efficient Query Processing in Arbitrary Subspaces Using Vector Approximations", booktitle="Proc. 18th Int. Conf. on Scientific and Statistical Database Management (SSDBM 06), Wien, Austria, 2006", url="http://dx.doi.org/10.1109/SSDBM.2006.23")
public class DAFile {
    private final int dimension;
    private final double[] splitPositions;

    public DAFile(Relation<? extends NumberVector> relation, int n, int n2) {
        int n3 = relation.size();
        this.dimension = n;
        this.splitPositions = new double[n2 + 1];
        double[] dArray = new double[n3];
        int n4 = 0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            dArray[n4] = relation.get(dBIDIter).doubleValue(n);
            ++n4;
            dBIDIter.advance();
        }
        Arrays.sort(dArray);
        for (int i = 0; i < n2; ++i) {
            int n5 = (int)((double)(i * n3) / (double)n2);
            this.splitPositions[i] = dArray[n5];
        }
        this.splitPositions[n2] = dArray[n3 - 1] + 1.0E-6;
    }

    public double[] getSplitPositions() {
        return this.splitPositions;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getIOCosts() {
        return this.splitPositions.length * 8 + 4;
    }
}

